% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_legend.R
\name{add_legend}
\alias{add_legend}
\title{Add a legend to an scplot}
\usage{
add_legend(
  object,
  labels = NULL,
  section_labels = c("Lines", "Phases"),
  case = 1,
  position = "right",
  datalines = TRUE,
  statlines = TRUE,
  phases = TRUE,
  title = NULL,
  text = NULL,
  background = NULL
)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{labels}{A Character vector with text labels.}

\item{section_labels}{A character vector of length two. The labels for the
lines section and phase section.}

\item{case}{Numerical vector with the case number or character string. \code{case = "all"} for all cases.}

\item{position}{The position ("none", "left", "right", "bottom", "top", or
two-element numeric vector) of the legend.}

\item{datalines}{If TRUE, a legend for the datalines is generated.}

\item{statlines}{If TRUE, a legend for the statlines is generated.}

\item{phases}{If TRUE, a legend for the phases is generated.
Note that you also have to set the \code{set_panel} argument
(e.g., \code{set_panel(fill = c("lightblue", "grey80"))}).}

\item{title}{A list with text style parameters for the title.}

\item{text}{List with text parameters (\verb{"family", "face", "colour", "size", "hjust", "vjust", "angle", "lineheight", "margin"}). See \code{\link[=element_text]{element_text()}}.}

\item{background}{A list with background styling arguments (fill, color,
size, linetype).}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}) with changed element
\code{legend}.
}
\description{
This function adds a legend to an \code{scplot} object. The legend can include
entries for datalines, statlines, and phases. You can customize the position
of the legend, as well as the text style for the title and text within the
legend.
}
\details{
Deprecated argument: The \code{labels} argument is deprecated. Please set the
\code{label} argument in the \code{add_statline} and \code{set_dataline} functions instead.
The legend can be customized to include different sections for
datalines, statlines, and phases. You can control which sections are
included in the legend using the \code{datalines}, \code{statlines}, and \code{phases}
arguments. The \code{position} argument allows you to specify where
the legend should be placed on the plot. You can also customize the text
style for the title and text within the legend using the \code{title} and \code{text}
arguments, respectively. The \code{background} argument allows you to set
the background style of the legend.
}
\examples{
data(exampleAB_add, package = "scan")
scplot(exampleAB_add) |>
  set_dataline("depression") |>
  add_statline("mean") |>
  add_legend()

scplot(exampleAB_add) |>
  set_dataline(label = "Pychological Wellbeing") |>
  set_dataline("depression", color = "darkblue", label = "Depression") |>
  add_statline("mean", label = "Wellbeing mean") |>
  add_statline("mean", variable = "depression", label = "Depression mean") |>
  set_phasenames(color = NA) |>
  set_panel(fill = c("lightblue", "grey80")) |>
  add_legend(
    position = "left",
    section_labels = c("Variables", "Section"),
    title = list(color = "brown", size = 10, face = 2),
    text = list(color = "darkgreen", size = 10, face = 2),
    background = list(color = "lightgrey")
  )
}
