% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeuratMarkers.R
\name{SeuratMarkers}
\alias{SeuratMarkers}
\title{A thresholded markers list for better calculation of DE genes}
\usage{
SeuratMarkers(lowdim_seurat_object)
}
\arguments{
\item{lowdim_seurat_object}{Seurat object with cluster information}
}
\value{
A list containing two marker lists:
- Full markers list
- Thresholded markers list with \code{min.pct = 0.1}
}
\description{
This function calculates differentially expressed genes using Seurat::FindAllMarkers.
}
\examples{
\donttest{
library(Seurat)
# Read 10X counts data from matrix.mtx, barcodes.tsv and genes.tsv
counts <- Read10X(data.dir = "../inst/extdata", gene.column = 1)

# Create Seurat object without batch correction
seurat_obj <- SeuratPreprocess(counts)
seurat_obj <- SeuratLowDim(seurat_obj)
# Create Markers list
seurat_markers <- SeuratMarkers(seurat_obj)
}
}
