% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_by_cluster.R
\name{scMetaTraj_trend_by_cluster}
\alias{scMetaTraj_trend_by_cluster}
\title{Compute module trends along mPT stratified by metabolic cluster}
\usage{
scMetaTraj_trend_by_cluster(
  score_mat,
  mPT,
  cluster,
  modules,
  n_bins = 30,
  smooth = TRUE,
  span = 0.3,
  min_cells = 50
)
}
\arguments{
\item{score_mat}{Matrix/data.frame (cells x modules).}

\item{mPT}{Numeric vector.}

\item{cluster}{Factor/character vector of cluster labels.}

\item{modules}{Character vector of module names.}

\item{n_bins}{Integer. Number of bins.}

\item{smooth}{Logical. Whether to loess smooth.}

\item{span}{Numeric. Loess span.}

\item{min_cells}{Integer. Minimum cells per cluster to compute trends.}
}
\value{
Long-format data.frame with columns:
cluster, module, mPT_bin, score, score_smooth, n_cells
}
\description{
Compute module trends along mPT stratified by metabolic cluster
}
