% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{scMetaTraj_score}
\alias{scMetaTraj_score}
\title{Calculate metabolic pathway scores for single cells}
\usage{
scMetaTraj_score(
  x,
  gene_sets,
  assay = "RNA",
  slot = "data",
  method = c("mean", "zscore"),
  min_genes = 3,
  scale = TRUE
)
}
\arguments{
\item{x}{A Seurat object or a gene x cell expression matrix.}

\item{gene_sets}{A named list: pathway -> character vector of genes.}

\item{assay}{Character. Seurat assay to use. Default "RNA".}

\item{slot}{Character. Expression slot. Default "data".}

\item{method}{Character. Scoring method: "mean" or "zscore".}

\item{min_genes}{Integer. Minimal number of detected genes per pathway.}

\item{scale}{Logical. Whether to z-score pathway scores across cells.}
}
\value{
A numeric matrix: cells x pathways.
}
\description{
scMetaTraj_score() maps gene-level expression to pathway-level
metabolic activity scores. The resulting matrix defines the
metabolic feature space used by all downstream scMetaTraj modules.

IMPORTANT:
\itemize{
\item Scores represent relative metabolic states, NOT metabolic flux.
\item Designed to be robust to dropout in scRNA-seq data.
}
}
