% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ggkmcif2}
\alias{ggkmcif2}
\title{Plot KM and CIF curves with ggplot}
\usage{
ggkmcif2(
  response,
  cov = NULL,
  data,
  pval = TRUE,
  conf.curves = FALSE,
  table = TRUE,
  xlab = "Time",
  ylab = NULL,
  col = NULL,
  times = NULL,
  type = NULL,
  plot.event = 1,
  returns = FALSE,
  ...
)
}
\arguments{
\item{response}{character vector with names of columns to use for response}

\item{cov}{String specifying the column name of stratification variable}

\item{data}{dataframe containing your data}

\item{pval}{boolean to specify if you want p-values in the plot (Log Rank
test for KM and Gray's test for CIF)}

\item{conf.curves}{boolean to specify if you want confidence interval bands}

\item{table}{Logical value. If TRUE, includes the number at risk table}

\item{xlab}{String corresponding to xlabel. By default is "Time"}

\item{ylab}{String corresponding to ylabel. When NULL uses "Survival}

\item{col}{vector of colours}

\item{times}{Numeric vector of times for the x-axis probability" for KM
cuves, and "Probability of an event" for CIF}

\item{type}{string indicating he type of univariate model to fit. The
function will try and guess what type you want based on your response. If
you want to override this you can manually specify the type. Options
include "KM", and ,"CIF"}

\item{plot.event}{Which event(s) to plot (1,2, or c(1,2))}

\item{returns}{boolean indicating if a list with the objects should be
returned. Default is FALSE and plot will be printed}

\item{...}{for additional plotting arguments see \link{ggkmcif2Parameters}}
}
\value{
ggplot object; if table = F then only curves are output; if table =
T then curves and risk table are output together
}
\description{
This function will plot a KM or CIF curve with option to add the number at
risk. You can specify if you want confidence bands, the hazard ratio, and
pvalues, as well as the units of time used.
}
\details{
Note that for proper pdf output of special characters the following code
needs to be included in the first chunk of the rmd
knitr::opts_chunk$set(dev="cairo_pdf")
}
\examples{
# Simple plot without confidence intervals
data("pembrolizumab")
ggkmcif2(response = c('os_time','os_status'),
cov='cohort',
data=pembrolizumab)

# Plot with median survival time
ggkmcif2(response = c('os_time','os_status'),
cov='sex',
data=pembrolizumab,
median.text = TRUE,median.lines=TRUE,conf.curves=TRUE)

# Plot with specified survival times and log-log CI
ggkmcif2(response = c('os_time','os_status'),
cov='sex',
data=pembrolizumab,
median.text = FALSE,set.time.text = 'mo OS',
set.time = c(12,24),conf.type = 'log-log',conf.curves=TRUE)

# KM plot with 95\% CI and censor marks
ggkmcif2(c('os_time','os_status'),'sex',data = pembrolizumab, type = 'KM',
HR=TRUE, HR_pval = TRUE, conf.curves = TRUE,conf.type='log-log',
set.time.CI = TRUE, censor.marks=TRUE)
}
