% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ru_groupbyvars.R
\name{ru_groupbyvars}
\alias{ru_groupbyvars}
\title{Modify groupbyvars by adding or removing decode vars.}
\usage{
ru_groupbyvars(groupbyvars, codedecodevarpairs, adddecode = TRUE)
}
\arguments{
\item{groupbyvars}{Vector of group-by variables.}

\item{codedecodevarpairs}{Specifies code and decode variable pairs. Those variables should be in parameter GROUPBYVARSNUMER.
One variable in the pair will contain the code, which is used in counting and ordering, and the other
will contain decode, which is used for presentation.}

\item{adddecode}{Add decode variables (true) or remove (false).}
}
\value{
A data frame based on the incoming data frame but collapsed by groups with counts and percents added.
}
\description{
Pass in a vector of group-by variables along with a vector of code/decode pairs to have decode variables added or removed.
}
\examples{
library(repfun)
add_decode <- repfun::ru_groupbyvars(
              c("TRTCD", "TRTGRP", "ATOXGRN", "AEDECOD", "AEBODSYS"),
              c("TRTCD", "TRTGRP", "ATOXGRN", "ATOXGR"), TRUE)
rem_decode <- repfun::ru_groupbyvars(
              c("TRTCD", "TRTGRP", "ATOXGRN", "AEDECOD", "AEBODSYS"),
              c("TRTCD", "TRTGRP", "ATOXGRN", "ATOXGR"), FALSE)

}
\author{
Yongwei Wang, \email{yongwei.x.wang@viivhealthcare.com} \cr
Chris Rook, \email{cr883296@gmail.com}
}
