% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_types_recipes.R
\name{.get_data_types}
\alias{.get_data_types}
\alias{.get_data_types.default}
\alias{.get_data_types.character}
\alias{.get_data_types.ordered}
\alias{.get_data_types.factor}
\alias{.get_data_types.integer}
\alias{.get_data_types.numeric}
\alias{.get_data_types.double}
\alias{.get_data_types.Surv}
\alias{.get_data_types.logical}
\alias{.get_data_types.Date}
\alias{.get_data_types.POSIXct}
\alias{.get_data_types.list}
\alias{.get_data_types.textrecipes_tokenlist}
\alias{.get_data_types.hardhat_case_weights}
\title{Get types for use in recipes}
\usage{
.get_data_types(x)

\method{.get_data_types}{default}(x)

\method{.get_data_types}{character}(x)

\method{.get_data_types}{ordered}(x)

\method{.get_data_types}{factor}(x)

\method{.get_data_types}{integer}(x)

\method{.get_data_types}{numeric}(x)

\method{.get_data_types}{double}(x)

\method{.get_data_types}{Surv}(x)

\method{.get_data_types}{logical}(x)

\method{.get_data_types}{Date}(x)

\method{.get_data_types}{POSIXct}(x)

\method{.get_data_types}{list}(x)

\method{.get_data_types}{textrecipes_tokenlist}(x)

\method{.get_data_types}{hardhat_case_weights}(x)
}
\arguments{
\item{x}{An object}
}
\description{
The \code{.get_data_types()} generic is used internally to supply types to columns
used in recipes. These functions underlie the work that the user sees in
\link{selections}.
}
\details{
This function acts as an extended recipes-specific version of \code{\link[=class]{class()}}. By
ignoring differences in similar types ("double" and "numeric") and allowing
each element to have multiple types ("factor" returns "factor", "unordered",
and "nominal", and "character" returns "string", "unordered", and "nominal")
we are able to create more natural selectors such as \code{\link[=all_nominal]{all_nominal()}},
\code{\link[=all_string]{all_string()}} and \code{\link[=all_integer]{all_integer()}}.

The following list shows the data types for different classes, as defined by
recipes. If an object has a class not supported by \code{.get_data_types()}, it
will get data type "other".
\itemize{
\item character: string, unordered, and nominal
\item ordered: ordered, and nominal
\item factor: factor, unordered, and nominal
\item integer: integer, and numeric
\item numeric: double, and numeric
\item double: double, and numeric
\item Surv: surv
\item logical: logical
\item Date: date
\item POSIXct: datetime
\item list: list
\item textrecipes_tokenlist: tokenlist
\item hardhat_case_weights: case_weights
}
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

data(Sacramento, package = "modeldata")
lapply(Sacramento, .get_data_types)
\dontshow{\}) # examplesIf}
}
\seealso{
\link{developer_functions}
}
