% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/querychat-package.R
\docType{package}
\name{querychat-package}
\alias{querychat-package}
\title{querychat: Chat with Your Data Using Natural Language}
\description{
querychat provides an interactive chat interface for querying data using
natural language. It translates your questions into SQL queries, executes
them against your data, and displays the results. The package works with
both data frames and database connections.
}
\section{Quick Start}{

The easiest way to get started is with the \link{QueryChat} R6 class:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(querychat)

# Create a QueryChat object (table name inferred from variable)
qc <- QueryChat$new(mtcars)

# Option 1: Run a complete app with sensible defaults
qc$app()

# Option 2: Build a custom Shiny app
ui <- page_sidebar(
  qc$sidebar(),
  dataTableOutput("data")
)

server <- function(input, output, session) \{
  qc$server()
  output$data <- renderDataTable(qc$df())
\}

shinyApp(ui, server)
}\if{html}{\out{</div>}}
}

\section{Key Features}{

\itemize{
\item \strong{Natural language queries}: Ask questions in plain English
\item \strong{SQL transparency}: See the generated SQL queries
\item \strong{Multiple data sources}: Works with data frames and database connections
\item \strong{Customizable}: Add data descriptions, extra instructions, and custom greetings
\item \strong{LLM agnostic}: Works with OpenAI, Anthropic, Google, and other providers via ellmer
}
}

\section{Main Components}{

\itemize{
\item \link{QueryChat}: The main R6 class for creating chat interfaces
\item \link{DataSource}, \link{DataFrameSource}, \link{DBISource}: R6 classes for data sources
}
}

\section{Examples}{

To see examples included with the package, run:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{shiny::runExample(package = "querychat")
}\if{html}{\out{</div>}}

This provides a list of available examples. To run a specific example, like
'01-hello-app', use:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{shiny::runExample("01-hello-app", package = "querychat")
}\if{html}{\out{</div>}}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://posit-dev.github.io/querychat/r/}
  \item \url{https://posit-dev.github.io/querychat/}
  \item \url{https://github.com/posit-dev/querychat}
  \item Report bugs at \url{https://github.com/posit-dev/querychat/issues}
}

}
\author{
\strong{Maintainer}: Garrick Aden-Buie \email{garrick@posit.co} (\href{https://orcid.org/0000-0002-7111-0077}{ORCID})

Authors:
\itemize{
  \item Joe Cheng \email{joe@posit.co} [conceptor]
  \item Carson Sievert \email{carson@posit.co} (\href{https://orcid.org/0000-0002-4958-2844}{ORCID})
}

Other contributors:
\itemize{
  \item Posit Software, PBC [copyright holder, funder]
}

}
\keyword{internal}
