% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting.R, R/priors.R
\name{student_t}
\alias{student_t}
\alias{student}
\alias{student_t_prior}
\title{Student's t Family for Robust Regression}
\usage{
student_t(
  link_or_df = "identity",
  location = 0,
  scale = 1,
  link = NULL,
  link.sigma = "log",
  link.nu = "log",
  ...
)

student()

student_t(
  link_or_df = "identity",
  location = 0,
  scale = 1,
  link = NULL,
  link.sigma = "log",
  link.nu = "log",
  ...
)

student_t_prior(
  link_or_df = 3,
  location = 0,
  scale = 1,
  link.sigma = "log",
  link.nu = "log"
)
}
\arguments{
\item{link_or_df}{For family: link function (character). For prior: degrees of freedom (numeric).}

\item{location}{Location parameter (prior only).}

\item{scale}{Scale parameter (prior only).}

\item{link}{Optional link function (if acting as family).}

\item{link.sigma}{Link for sigma (family only).}

\item{link.nu}{Link for nu (family only).}

\item{...}{Additional arguments.}
}
\value{
An object of class \code{"family"} specifying the Student-t distribution.

An object of class \code{"family"} specifying the Student-t distribution.

A family object or prior object depending on inputs.
}
\description{
Student's t-distribution family for robust regression with heavier tails
than Gaussian to handle outliers.

Functions that act as both family constructors (for \code{qbrm}) and prior
specifications (for \code{prior}), depending on arguments.
}
\examples{
# Create a Student-t family object
fam <- student_t()
print(fam$family)

}
