% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_parmsetter_nlmixr.R
\name{nn_parm_setter_nlmixr}
\alias{nn_parm_setter_nlmixr}
\title{Internal: Definition of NN parameters in nlmixr}
\usage{
nn_parm_setter_nlmixr(
  number,
  pop = FALSE,
  n_hidden = 5,
  eta_model = c("prop", "add"),
  time_nn = FALSE
)
}
\arguments{
\item{number}{(string) Name of the NN, e.g., \dQuote{1} for NN1(...)}

\item{pop}{(boolean) Whether population fit without inter-individual variability is performed (TRUE)
or whether model is fitted with inter-individual variability (FALSE)}

\item{n_hidden}{(numeric) Number of neurons in the hidden layer, default value is 5}

\item{eta_model}{(string)
\itemize{
  \item \dQuote{prop} is of form W = lW * EXP(etaW)
  \item \dQuote{add} is of form W = lW + etaW
}
Defaul value is \dQuote{prop}}

\item{time_nn}{(boolean) Definition whether NN is time-dependent (TRUE) or not (FALSE)}
}
\value{
List of parameter definition to be used in the \emph{model} section of the nlmixr model
}
\description{
Define NN parameters consisting of typical parameter and potentially random effects in the \emph{model} section
of a nlmixr model
}
\details{
\emph{eta_model} is currently set to proportional as previous investigations showed better stability of fit
with this setting
}
\author{
Dominic Bräm
}
\keyword{internal}
