% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmrm_data.R
\name{pmrm_data}
\alias{pmrm_data}
\title{Internal function to prepare data}
\usage{
pmrm_data(data, outcome, time, patient, visit, arm, covariates = ~0)
}
\arguments{
\item{data}{A \code{tibble} or data frame with one row per patient visit.
See the arguments below for specific requirements for the data.}

\item{outcome}{Character string, name of the column in the data
with the numeric outcome variable on the continuous scale.
Could be a clinical measure of healthy or of disease severity.
Baseline is part of the model, so the \code{outcome} should
not already be a change from baseline.
The vector of outcomes may have missing values, either with explicit
\code{NA}s or with rows in the data missing for one or more visits.}

\item{time}{Character string, name of the column in the data
with the numeric time variable on the continuous scale.
This time is the time since enrollment/randomization of each patient.
A time value of 0 should indicate baseline.}

\item{patient}{Character string, name of the column in the data
with the patient ID.
This vector could be a numeric, integer, factor, or character vector.
\code{pmrm} automatically converts it into an unordered factor.}

\item{visit}{Character string, name of the column in the
data which indicates the study visit of each row.
This column could be a numeric, integer, factor, or character vector.
An ordered factor is highly recommended because \code{pmrm}
with levels assumed to be in chronological order.
The minimum visit must be baseline.}

\item{arm}{Character string, name of the column in the
data which indicates the study arm of each row.
This column could be a numeric, integer, factor, or character vector.
An ordered factor is highly recommended because \code{pmrm}
automatically converts \code{data[[arm]]} into an ordered factor anyway.
The minimum level is assumed to be the control arm.}

\item{covariates}{Partial right-sided formula
of concomitant terms in the model
for covariate adjustment (e.g. by age, gender, biomarker status, etc.).
Should not include main variables such as the values of
\code{outcome}, \code{time}, \code{patient}, \code{visit}, or \code{arm}.
The columns in the data referenced in the formula must not have
any missing values.

Set \code{covariates} to \code{~ 0} (default) to opt out of covariate adjustment.
The intercept term is removed from the model matrix \code{W}
whether or not the formula begins with `~ 0.}
}
\value{
A \code{tibble} of class \code{"pmrm_data"}
with one row per patient visit.
Rows with missing outcomes are removed,
variables \code{arm} and \code{visit} are converted into ordered factors
(with minimum values at the control arm and baseline, respectively),
and then the rows are sorted by patient and visit.
The \code{"labels"} attribute is a named list with the values of arguments
\code{outcome}, \code{time}, \code{visit}, \code{arm}, and \code{covariates}.
}
\description{
Clean and annotate the data to prepare it for modeling.
}
\keyword{internal}
