% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intermap2d.R
\name{intermap2d}
\alias{intermap2d}
\title{2-D latent-space interaction map (persons vs. items)}
\usage{
intermap2d(
  z,
  w,
  gamma = NULL,
  person_group = NULL,
  item_group = NULL,
  person_colors = NULL,
  item_colors = NULL,
  alpha = NULL,
  beta = NULL,
  z_shape_size_scale = FALSE,
  w_shape_size_scale = FALSE,
  z_shape_size_range = c(2, 6),
  w_shape_size_range = c(2, 8),
  z_shape_size = 2.5,
  w_shape_size = 3,
  z_label_size_scale = NULL,
  w_label_size_scale = NULL,
  z_label_size_range = c(3, 7),
  w_label_size_range = c(3, 7),
  z_label_color = "navy",
  w_label_color = "firebrick",
  z_label_size = 4,
  w_label_size = 4,
  z_shape_opacity_scale = FALSE,
  w_shape_opacity_scale = FALSE,
  z_shape_opacity_range = c(0.3, 1),
  w_shape_opacity_range = c(0.3, 1),
  z_shape_fixed_opacity = NULL,
  w_shape_fixed_opacity = NULL,
  z_shape_color_gradient = FALSE,
  w_shape_color_gradient = FALSE,
  z_shape_color_values = NULL,
  w_shape_color_values = NULL,
  shape_color_gradient_low = "grey80",
  shape_color_gradient_high = "navy",
  z_shape_color_gradient_low = NULL,
  z_shape_color_gradient_high = NULL,
  w_shape_color_gradient_low = NULL,
  w_shape_color_gradient_high = NULL,
  show_ticks = FALSE,
  xlim_range = NULL,
  ylim_range = NULL,
  itemlabels = NULL,
  personlabels = NULL,
  figuretitle = NULL,
  z_shape = 16,
  w_shape = 17,
  z_shape_color = "navy",
  w_shape_color = "firebrick",
  z_border_width = 0.5,
  show_z_labels = FALSE,
  show_w_labels = FALSE,
  show_z_shapes = TRUE,
  show_w_shapes = TRUE,
  legend_title = "legend",
  show_size_legend = FALSE,
  share_gradient_scale = FALSE,
  legend_title_z = expression(alpha[p]),
  legend_title_w = expression(beta[i])
)
}
\arguments{
\item{z, w}{Numeric matrices with 2 columns: coordinates for persons/items.}

\item{gamma}{Optional scalar stretch factor applied to both z and w.}

\item{person_group, item_group}{Optional factor/character for grouping colors.}

\item{person_colors, item_colors}{Optional explicit color vectors (length N/I).}

\item{alpha, beta}{Optional vectors used to scale shape/label sizes, opacity,
and (optionally) gradients for persons/items, respectively.}

\item{z_shape_size_scale, w_shape_size_scale}{Logical: scale shape sizes by alpha/beta.}

\item{z_shape_size_range, w_shape_size_range}{Length-2 numeric: shape size ranges (when scaling).}

\item{z_shape_size, w_shape_size}{Numeric: fixed shape sizes when size scaling is OFF.}

\item{z_label_size_scale, w_label_size_scale}{Logical: scale label sizes.
If \code{NULL}, defaults to the corresponding shape-size flag.}

\item{z_label_size_range, w_label_size_range}{Length-2 numeric: label size ranges.}

\item{z_label_color, w_label_color}{Label colors; if \code{NULL}, labels follow the
layer's color (group/gradient) or fixed color/vector as appropriate.}

\item{z_label_size, w_label_size}{Fixed label sizes when not scaling.}

\item{z_shape_opacity_scale, w_shape_opacity_scale}{Logical: scale shape opacity by alpha/beta.}

\item{z_shape_opacity_range, w_shape_opacity_range}{Length-2 numeric: opacity ranges.}

\item{z_shape_fixed_opacity, w_shape_fixed_opacity}{Optional constant opacity (0..1) for shapes.}

\item{z_shape_color_gradient, w_shape_color_gradient}{Logical: color shapes by a gradient
(darker indicates higher). Overrides groups/colors for that layer. If both are \code{TRUE},
the gradients can be shared (\code{share_gradient_scale = TRUE}) or separated
(\code{share_gradient_scale = FALSE}, default).}

\item{z_shape_color_values, w_shape_color_values}{Optional numeric drivers for gradients
(defaults: \code{alpha} / \code{beta} respectively).}

\item{shape_color_gradient_low, shape_color_gradient_high}{Global colors for the gradient
palette. Used directly when \code{share_gradient_scale = TRUE}, or as fallbacks
for layer-specific palettes when \code{share_gradient_scale = FALSE}.}

\item{z_shape_color_gradient_low, z_shape_color_gradient_high}{Optional colors for the
persons (z) gradient when using separate scales. If \code{NULL}, fall back to
\code{shape_color_gradient_low/high}.}

\item{w_shape_color_gradient_low, w_shape_color_gradient_high}{Optional colors for the
items (w) gradient when using separate scales. If \code{NULL}, fall back to
\code{shape_color_gradient_low/high}.}

\item{show_ticks}{Logical: draw axis ticks/labels.}

\item{xlim_range, ylim_range}{Optional axis limits (symmetric if \code{NULL}).}

\item{itemlabels, personlabels}{Optional labels (defaults: "I1..", "P1..").}

\item{figuretitle}{Optional plot title.}

\item{z_shape, w_shape}{ggplot2 shape codes for persons/items (see \code{?ggplot2::geom_point}).}

\item{z_shape_color, w_shape_color}{Fixed fallback shape colors when not mapping.}

\item{z_border_width}{Stroke width for z shapes (when applicable).}

\item{show_z_labels, show_w_labels}{Logical: draw labels for z/w.}

\item{show_z_shapes, show_w_shapes}{Logical: draw shapes for z/w.}

\item{legend_title}{Character or expression: the legend title (when shown).}

\item{show_size_legend}{Logical: show a size legend (default \code{FALSE}).}

\item{share_gradient_scale}{Logical. If \code{TRUE}, persons and items share \strong{one}
gradient/legend (uses \code{shape_color_gradient_low/high} and \code{legend_title}).
If \code{FALSE} (default), persons and items use \strong{separate} gradients/legends:
persons mapped to color (title \code{legend_title_z}) and items mapped to fill
(title \code{legend_title_w}).}

\item{legend_title_z, legend_title_w}{Titles (character or expressions) for the
separate z and w gradient legends, used only when
\code{share_gradient_scale = FALSE} and both gradient mappings are enabled.}
}
\value{
Invisibly returns a \code{ggplot} object; also prints the plot.
}
\description{
Persons (\eqn{z}{z}) and items (\eqn{w}{w}) in a 2D latent space with flexible styling.
Person parameter \eqn{\alpha_p}{alpha_p}, item parameter \eqn{\beta_i}{beta_i}.
}
\details{
\strong{Coloring & legends}
\itemize{
\item A color legend appears when colors are mapped via groups or gradients.
For fixed colors/shapes on both layers, the function creates a simple
two-entry legend ("Persons", "Items") using constant mappings; when shapes
are off but labels are on, it builds a labels-only legend with colored
swatches. The legend title is controlled by \code{legend_title}.
\item When both persons and items use gradient coloring
(\code{z_shape_color_gradient = TRUE} and \code{w_shape_color_gradient = TRUE}),
you can either \strong{share one gradient and legend} by setting
\code{share_gradient_scale = TRUE} (uses \code{shape_color_gradient_low/high} and
\code{legend_title}), or show \strong{separate gradients/legends} for z and w by
keeping \code{share_gradient_scale = FALSE} (default). In separate mode,
persons use the color scale with title \code{legend_title_z}, and items
use the fill scale with title \code{legend_title_w}. Layer-specific palettes
can be supplied via \code{z_shape_color_gradient_low/high} and
\code{w_shape_color_gradient_low/high}; if \code{NULL}, the global
\code{shape_color_gradient_low/high} are used as fallbacks.
\item Opacity (ggplot "alpha") and size legends are hidden by default. Set
\code{show_size_legend = TRUE} to show a size legend when size mapping is used.
\item When \code{person_colors} / \code{item_colors} are \strong{vectors} and \code{z_label_color} /
\code{w_label_color} are \code{NULL}, label colors follow those per-observation vectors.
}

\strong{Opacity}
\itemize{
\item Transparency is called \emph{opacity} to avoid confusion with the statistic
\code{alpha}. When you supply explicit fixed colors (single color or vector),
default opacity is full (\code{1}) unless you enable \verb{*_shape_opacity_scale}
or set \verb{*_shape_fixed_opacity}.
}

\strong{Sizes}
\itemize{
\item Shape sizes are fixed by \code{z_shape_size} / \code{w_shape_size} unless
\code{z_shape_size_scale} / \code{w_shape_size_scale} are \code{TRUE}, in which case
sizes are scaled by \code{alpha} / \code{beta} into \code{z_shape_size_range} /
\code{w_shape_size_range}.
\item Label text sizes are fixed by \code{z_label_size} / \code{w_label_size} unless
\code{z_label_size_scale} / \code{w_label_size_scale} are \code{TRUE}, in which case they
are scaled by \code{alpha} / \code{beta} into \code{z_label_size_range} / \code{w_label_size_range}.
}
}
\examples{
### example data
set.seed(1)
z <- matrix(rnorm(40), 20, 2)  # persons
w <- matrix(rnorm(30), 15, 2)  # items
alpha <- rnorm(nrow(z))        # person alpha
beta  <- rnorm(nrow(w))        # item beta

### 1) minimal, fixed colors & shapes
intermap2d(z, w)

### 2) minimal, fixed shapes for persons and labels for items
intermap2d(
  z, w,
  show_w_shapes = FALSE, show_w_labels = TRUE
)

### 3) Grouped colors + sized shapes, formal legend title
intermap2d(
  z, w,
  person_group = rep(c("Cohort A", "Cohort B"), length.out = nrow(z)),
  item_group   = rep(c("Domain X", "Domain Y", "Domain Z"), length.out = nrow(w)),
  alpha = alpha, beta = beta,
  z_shape_size_scale = TRUE, z_shape_size_range = c(2, 6),
  w_shape_size_scale = TRUE, w_shape_size_range = c(2, 8),
  show_z_shapes = TRUE, show_w_shapes = FALSE,
  show_w_labels = TRUE, legend_title = "Cohort / Domain"
)

### 4) Gradient for persons only (darker = higher alpha), labels scaled by alpha
intermap2d(
  z, w,
  alpha = alpha,
  z_shape_color_gradient = TRUE,     # z by gradient
  w_shape_color          = "red",    # w fixed color
  z_label_size_scale     = TRUE,     # label size proportional to alpha
  show_w_shapes = FALSE,
  show_w_labels = TRUE,
  # shape_color_gradient_low = "grey80", shape_color_gradient_high = "navy",
  legend_title = expression(alpha[p])
)

### 5) Gradient for both alpha (persons) and beta (items), shared legend
intermap2d(
  z, w,
  alpha = alpha, beta = beta,
  z_shape_color_gradient = TRUE, w_shape_color_gradient = TRUE,
  shape_color_gradient_low = "grey80", shape_color_gradient_high = "navy",
  z_shape_size_scale = TRUE, w_shape_size_scale = TRUE,
  show_z_shapes = TRUE, show_w_shapes = TRUE,
  show_z_labels = FALSE, show_w_labels = FALSE,
  legend_title = "Intensity (alpha persons, beta items)"
)

### 6) Explicit per-observation colors (vectors) + label-only
z_cols <- ifelse(alpha > 0, "#1f77b4", "#AEC7E8")
w_cols <- ifelse(beta  > 0, "#d62728", "#FF9896")
intermap2d(
  z, w,
  person_colors = z_cols, item_colors = w_cols,
  show_z_shapes = FALSE, show_w_shapes = FALSE,
  show_z_labels = TRUE,  show_w_labels = TRUE
)

### 7) Opacity scaling + fixed shape sizes
intermap2d(
  z, w,
  alpha = alpha, beta = beta,
  z_shape_opacity_scale = TRUE,  z_shape_opacity_range = c(0.2, 1.0),
  w_shape_opacity_scale = TRUE,  w_shape_opacity_range = c(0.4, 1.0),
  z_shape_color = "black", w_shape_color = "orange3",
  z_shape_size = 3, w_shape_size = 3.5,        # fixed sizes (no size scaling)
  show_z_shapes = TRUE, show_w_shapes = TRUE
)

### 8) Label-only scaling; shape sizes fixed; custom legend title for groups
intermap2d(
  z, w,
  person_group = rep(c("High", "Low"), length.out = nrow(z)),
  alpha = alpha, beta = beta,
  z_label_size_scale = TRUE, w_label_size_scale = TRUE,
  z_label_size_range = c(3, 7), w_label_size_range = c(3, 7),
  show_z_labels = TRUE, show_w_labels = FALSE,
  show_z_shapes = FALSE, show_w_shapes = TRUE,
  legend_title = "Performance Group"
)

### 9) Stretch coordinates + axis ticks + symmetric limits
intermap2d(
  z, w,
  gamma = 1.5,
  show_ticks = TRUE,
  xlim_range = c(-4, 4), ylim_range = c(-4, 4),
  person_group = rep(c("Train","Test"), length.out = nrow(z)),
  legend_title = "Set Membership"
)

}
