% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtern.R
\name{stat_3logit}
\alias{stat_3logit}
\title{Add a field and confidence regions to a \code{gg3logit} plot}
\usage{
stat_3logit(
  mapping_field = aes(),
  mapping_conf = aes(),
  data = NULL,
  params_field = list(),
  params_conf = list(),
  show.legend = NA,
  inherit.aes = TRUE,
  conf = TRUE
)
}
\arguments{
\item{mapping_field, mapping_conf}{aesthetic mappings passed to argument
\code{mapping} of \code{\link[=stat_field3logit]{stat_field3logit()}} and \code{\link[=stat_conf3logit]{stat_conf3logit()}}.}

\item{data}{a \code{field3logit} object, a \code{multifield3logit} object, or
a \code{data.frame} structured like a fortified \code{field3logit} or a
\code{multifield3logit} object.}

\item{params_field, params_conf}{graphical parameters passed to argument
\code{mapping} of \code{\link[=stat_field3logit]{stat_field3logit()}} and \code{\link[=stat_conf3logit]{stat_conf3logit()}}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{conf}{if \code{TRUE} and if confidence regions are available, the layer of
\code{\link[=stat_conf3logit]{stat_conf3logit()}} is added, otherwise only the layer of
\code{\link[=stat_field3logit]{stat_field3logit()}} is returned.}
}
\value{
If \code{conf} is set to \code{FALSE} a layer of \code{ggplot} package is returned
(object of class \code{LayerInstance}), otherwise, if \code{conf} is set to \code{TRUE},
\code{stat_3logit} returns a list of two \code{ggplot2} layers (class \code{LayerInstance}).
}
\description{
\code{\link[=stat_3logit]{stat_3logit()}} adds a field and confidence regions to a \code{\link{gg3logit}}
plot. \code{\link[=stat_3logit]{stat_3logit()}} is a wrapper for stats \code{\link[=stat_field3logit]{stat_field3logit()}} and
\code{\link[=stat_conf3logit]{stat_conf3logit()}} which are jointly applied.
}
\examples{
\donttest{
data(cross_1year)

mod0 <- nnet::multinom(employment_sit ~ gender + finalgrade, data = cross_1year)
field0 <- field3logit(mod0, 'genderFemale', conf = 0.95)

gg3logit(field0) + stat_3logit()
gg3logit(field0) + stat_3logit(conf = TRUE)
}

}
\seealso{
Other gg functions: 
\code{\link{autoplot.Hfield3logit}()},
\code{\link{gg3logit}()},
\code{\link{stat_conf3logit}()},
\code{\link{stat_field3logit}()}
}
\concept{gg functions}
