% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_common.R
\name{pc2p0}
\alias{pc2p0}
\alias{pc2p0_single}
\title{Computation of starting points of curves of the field}
\usage{
pc2p0(pc, DeltaB, edge = 0.01, flink)

pc2p0_single(pc, DeltaB, w, edge, flink)
}
\arguments{
\item{pc}{\code{list} of ternary coordinates, as returned by
\code{\link[=DeltaB2pc_cat3logit]{DeltaB2pc_cat3logit()}} or \code{\link[=DeltaB2pc_ord3logit]{DeltaB2pc_ord3logit()}}.
Function \code{pc2p0_single} accepts only a single point
(that is a \code{numeric} vector of length three).}

\item{DeltaB}{either a matrix \eqn{\Delta^TB\in\textbf{R}^{1\times 2}}
or a vector of length 2, if the model is \emph{categorical}; otherwise
a matrix \eqn{\Delta^TB\in\textbf{R}^{1\times 1}} or a \code{numeric},
if the model is \emph{ordinal}.}

\item{edge}{width of the border of the ternary plot.}

\item{flink}{named \code{list} of two functions: \code{linkfun}
and \code{linkinv}. The former is the link function, whereas
the latter is its inverse.}
}
\value{
A named \code{list} with two components:

\item{status}{a \code{character} always equal to \code{"p0"}
(see section \emph{Value} of \code{\link[=DeltaB2pc]{DeltaB2pc()}}).}
\item{pp}{a \code{list} of ternary coordinates.}
}
\description{
Given the output of \code{\link[=DeltaB2pc_cat3logit]{DeltaB2pc_cat3logit()}} or
\code{\link[=DeltaB2pc_ord3logit]{DeltaB2pc_ord3logit()}}, the coordinates of points on the
edge are computed for each curve of the field of points
given in input.
}
\keyword{internal}
