% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_landmarks.R
\name{ellipse}
\alias{ellipse}
\title{Confidence ellipse}
\usage{
ellipse(
  x,
  conf = 0.95,
  np = 100,
  plot = TRUE,
  fill = "green",
  alpha = 0.3,
  random_fill = TRUE
)
}
\arguments{
\item{x}{A \code{matrix}, a \code{data.frame} or a \code{list} of perimeter coordinates, often
produced with \code{\link[=object_contour]{object_contour()}}.}

\item{conf}{The confidence level. Defaults to \code{0.95}}

\item{np}{Number of sampled points on the ellipse.}

\item{plot}{Create a plot? Defaults to \code{TRUE}.}

\item{fill}{The color to fill the ellipse. Defaults to \code{"green"}.}

\item{alpha}{The alpha value to define the opacity of ellipse. Defaults to
\code{0.3}}

\item{random_fill}{Fill multiple ellipses with random colors? Defaults to
\code{TRUE}.}
}
\value{
A matrix with coordinates of points sampled on the ellipse.
}
\description{
Produces a confidence ellipse that is an iso-contour of the Gaussian
distribution, allowing to visualize a 2D confidence interval.
}
\note{
Borrowed from Claude (2008), pp. 85
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
ellipse(contours)
}
}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.
}
