% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbstractGraphReporter.R
\name{AbstractGraphReporter}
\alias{AbstractGraphReporter}
\title{Abstract Network Reporter Class}
\description{
\pkg{pkgnet} defines several package reporter R6 classes that model
a particular network aspect of a package as a graph. These network
reporter classes are extended from \code{AbstractGraphReporter}, which
itself extends the \code{\link[=AbstractPackageReporter]{AbstractPackageReporter}}
with graph-modeling-related functionality. 

This article describes the additional fields added by the \code{AbstractGraphReporter} class definition.
}
\concept{Reporters}
\keyword{internal}
\section{Super class}{
\code{\link[pkgnet:AbstractPackageReporter]{pkgnet::AbstractPackageReporter}} -> \code{AbstractGraphReporter}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{nodes}}{A data.table, containing information about
the nodes of the network the reporter is analyzing. The \code{node} 
column acts the identifier. Read-only.}

\item{\code{edges}}{A data.table, containing information about
the edge connections of the network the reporter is analyzing. Each
row is one edge, and the columns \code{SOURCE} and \code{TARGET}
specify the node identifiers. Read-only.}

\item{\code{network_measures}}{A list, containing any measures 
of the network calculated by the reporter. Read-only.}

\item{\code{pkg_graph}}{a graph model object. See \link{DirectedGraph}
for additional documentation. Read-only.}

\item{\code{graph_viz}}{a graph visualization object. A 
\code{\link[visNetwork:visNetwork]{visNetwork::visNetwork}} object.
Read-only.}

\item{\code{layout_type}}{a character string, the current layout type for the graph visualization. 
Can be assigned a new valid layout type value. Use use \code{grep("^layout_\\\\S", getNamespaceExports("igraph"), value = TRUE)} to see valid options.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AbstractGraphReporter-calculate_default_measures}{\code{AbstractGraphReporter$calculate_default_measures()}}
\item \href{#method-AbstractGraphReporter-get_summary_view}{\code{AbstractGraphReporter$get_summary_view()}}
\item \href{#method-AbstractGraphReporter-clone}{\code{AbstractGraphReporter$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractPackageReporter" data-id="set_package"><a href='../../pkgnet/html/AbstractPackageReporter.html#method-AbstractPackageReporter-set_package'><code>pkgnet::AbstractPackageReporter$set_package()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractGraphReporter-calculate_default_measures"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractGraphReporter-calculate_default_measures}{}}}
\subsection{Method \code{calculate_default_measures()}}{
Calculates the default node and network measures for this reporter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractGraphReporter$calculate_default_measures()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractGraphReporter-get_summary_view"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractGraphReporter-get_summary_view}{}}}
\subsection{Method \code{get_summary_view()}}{
Creates a summary table formatted for display.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractGraphReporter$get_summary_view()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{DT} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractGraphReporter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractGraphReporter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractGraphReporter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
