% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{latinize}
\alias{latinize}
\title{Latinization}
\usage{
latinize(x, encoding = "latin1")
}
\arguments{
\item{x}{A character vector.}

\item{encoding}{Encoding that the strings in \code{x} should be
converted to. If the conversion fails, defaults back to the original
encoding. Defaults to \code{"latin1"}.}
}
\value{
The transliterated vector of the same length as \code{x}. \code{NA}s
are avoided.
}
\description{
Helper tool to transliterate various encodings to latin. Attempts to
convert a character vector from its current encoding to \code{"latin1"} and -
if it fails - defaults back to the original term. This can be useful
for \code{\link{geocode}} and \code{\link{structured}} when attempting to
geocode terms containing symbols that photon does not support.
}
\examples{
# converts fancy apostrophes to normal ones
latinize("Luatuanu\u2019u")

# does nothing
latinize("Berlin")

# also does nothing, although it would fail with `iconv`
latinize("\u0391\u03b8\u03ae\u03bd\u03b1")
}
