% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_non_negative_numeric.R
\name{is_non_negative_numeric}
\alias{is_non_negative_numeric}
\title{Check if a Number is a Non-Negative Numeric}
\usage{
is_non_negative_numeric(x, name_of_func, throw_error = TRUE)
}
\arguments{
\item{x}{The input to check. Should be a single numeric value.}

\item{name_of_func}{Name of function to return as error message}

\item{throw_error}{Logical. If \code{TRUE}, the function throws an error when the input is invalid.
Defaults to \code{FALSE}, in which case the function returns \code{FALSE} for invalid inputs.}
}
\value{
A logical value:
\itemize{
\item \code{TRUE} if \code{x} is a non-negative numeric scalar.
\item \code{FALSE} if \code{x} is not a non-negative numeric scalar`.
}
}
\description{
This internal function checks whether the input is a non-negative numeric scalar.
It can optionally throw an error if the input is invalid.
}
\details{
This function is intended for internal use within the package to validate numeric inputs.
It ensures that the input is numeric, has a length of 1, and is greater than 0.
}
\keyword{internal}
