% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_orderable_db_instance_options}
\alias{rds_describe_orderable_db_instance_options}
\title{Describes the orderable DB instance options for a specified DB engine}
\usage{
rds_describe_orderable_db_instance_options(
  Engine,
  EngineVersion = NULL,
  DBInstanceClass = NULL,
  LicenseModel = NULL,
  AvailabilityZoneGroup = NULL,
  Vpc = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{Engine}{[required] The name of the database engine to describe DB instance options for.

Valid Values:
\itemize{
\item \code{aurora-mysql}
\item \code{aurora-postgresql}
\item \code{custom-oracle-ee}
\item \code{custom-oracle-ee-cdb}
\item \code{custom-oracle-se2}
\item \code{custom-oracle-se2-cdb}
\item \code{db2-ae}
\item \code{db2-se}
\item \code{mariadb}
\item \code{mysql}
\item \code{oracle-ee}
\item \code{oracle-ee-cdb}
\item \code{oracle-se2}
\item \code{oracle-se2-cdb}
\item \code{postgres}
\item \code{sqlserver-ee}
\item \code{sqlserver-se}
\item \code{sqlserver-ex}
\item \code{sqlserver-web}
}}

\item{EngineVersion}{A filter to include only the available options for the specified engine
version.}

\item{DBInstanceClass}{A filter to include only the available options for the specified DB
instance class.}

\item{LicenseModel}{A filter to include only the available options for the specified license
model.

RDS Custom supports only the BYOL licensing model.}

\item{AvailabilityZoneGroup}{The Availability Zone group associated with a Local Zone. Specify this
parameter to retrieve available options for the Local Zones in the
group.

Omit this parameter to show the available options in the specified
Amazon Web Services Region.

This setting doesn't apply to RDS Custom DB instances.}

\item{Vpc}{Specifies whether to show only VPC or non-VPC offerings. RDS Custom
supports only VPC offerings.

RDS Custom supports only VPC offerings. If you describe non-VPC
offerings for RDS Custom, the output shows VPC offerings.}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 1000.}

\item{Marker}{An optional pagination token provided by a previous
DescribeOrderableDBInstanceOptions request. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords}.}
}
\description{
Describes the orderable DB instance options for a specified DB engine.

See \url{https://www.paws-r-sdk.com/docs/rds_describe_orderable_db_instance_options/} for full documentation.
}
\keyword{internal}
