% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_copy_db_cluster_parameter_group}
\alias{rds_copy_db_cluster_parameter_group}
\title{Copies the specified DB cluster parameter group}
\usage{
rds_copy_db_cluster_parameter_group(
  SourceDBClusterParameterGroupIdentifier,
  TargetDBClusterParameterGroupIdentifier,
  TargetDBClusterParameterGroupDescription,
  Tags = NULL
)
}
\arguments{
\item{SourceDBClusterParameterGroupIdentifier}{[required] The identifier or Amazon Resource Name (ARN) for the source DB cluster
parameter group. For information about creating an ARN, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing}{Constructing an ARN for Amazon RDS}
in the \emph{Amazon Aurora User Guide}.

Constraints:
\itemize{
\item Must specify a valid DB cluster parameter group.
}}

\item{TargetDBClusterParameterGroupIdentifier}{[required] The identifier for the copied DB cluster parameter group.

Constraints:
\itemize{
\item Can't be null, empty, or blank
\item Must contain from 1 to 255 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-cluster-param-group1}}

\item{TargetDBClusterParameterGroupDescription}{[required] A description for the copied DB cluster parameter group.}

\item{Tags}{}
}
\description{
Copies the specified DB cluster parameter group.

See \url{https://www.paws-r-sdk.com/docs/rds_copy_db_cluster_parameter_group/} for full documentation.
}
\keyword{internal}
