% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_modify_db_cluster_snapshot_attribute}
\alias{neptune_modify_db_cluster_snapshot_attribute}
\title{Adds an attribute and values to, or removes an attribute and values
from, a manual DB cluster snapshot}
\usage{
neptune_modify_db_cluster_snapshot_attribute(
  DBClusterSnapshotIdentifier,
  AttributeName,
  ValuesToAdd = NULL,
  ValuesToRemove = NULL
)
}
\arguments{
\item{DBClusterSnapshotIdentifier}{[required] The identifier for the DB cluster snapshot to modify the attributes for.}

\item{AttributeName}{[required] The name of the DB cluster snapshot attribute to modify.

To manage authorization for other Amazon accounts to copy or restore a
manual DB cluster snapshot, set this value to \code{restore}.}

\item{ValuesToAdd}{A list of DB cluster snapshot attributes to add to the attribute
specified by \code{AttributeName}.

To authorize other Amazon accounts to copy or restore a manual DB
cluster snapshot, set this list to include one or more Amazon account
IDs, or \code{all} to make the manual DB cluster snapshot restorable by any
Amazon account. Do not add the \code{all} value for any manual DB cluster
snapshots that contain private information that you don't want available
to all Amazon accounts.}

\item{ValuesToRemove}{A list of DB cluster snapshot attributes to remove from the attribute
specified by \code{AttributeName}.

To remove authorization for other Amazon accounts to copy or restore a
manual DB cluster snapshot, set this list to include one or more Amazon
account identifiers, or \code{all} to remove authorization for any Amazon
account to copy or restore the DB cluster snapshot. If you specify
\code{all}, an Amazon account whose account ID is explicitly added to the
\code{restore} attribute can still copy or restore a manual DB cluster
snapshot.}
}
\description{
Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.

See \url{https://www.paws-r-sdk.com/docs/neptune_modify_db_cluster_snapshot_attribute/} for full documentation.
}
\keyword{internal}
