% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics_api.R
\name{pa_get_vi_stats}
\alias{pa_get_vi_stats}
\title{Request  vegetation index statistics from the Data
  Space Statistics API}
\usage{
pa_get_vi_stats(
  aoi,
  start.date,
  end.date,
  collection = c("sentinel-2-l2a"),
  vegetation.index = c("bsi", "evi", "gcvi", "ndre", "ndvi", "reci"),
  agg.time = c("P1D", "P5D", "P10D"),
  by.feature = FALSE
)
}
\arguments{
\item{aoi}{sf object used to filter satellite products}

\item{start.date}{beginning of the time window to filter
satellite products. Date format should be `\%Y-\%m-\%d`.}

\item{end.date}{end of the time window to filter
satellite products. Date format should be `\%Y-\%m-\%d`.}

\item{collection}{for now, it only supports 'sentinel2'.}

\item{vegetation.index}{vegetation index to be requested
from the Data Space}

\item{agg.time}{aggregation time of the satellite
products}

\item{by.feature}{logical, indicating whether the
statistics should be retrieved by each polygon when
multiple polygons are supplied in \sQuote{aoi}}
}
\value{
returns an object of class veg.index and stars
}
\description{
Request  vegetation index statistics from
  the Data Space Statistics API
}
\details{
`pa_get_vi_sentinel2()` will use HTTP requests to
  communicate with the Data Space Statistics API and
  request areal statistics for the specified vegetation
  index
}
\examples{
\dontrun{
extd.dir <- system.file("extdata", package = "pacu")
area.of.interest <- sf::st_read(file.path(extd.dir, 'cobs_a_aoi.shp'), quiet = TRUE)
ndvi <- pa_get_vi_stats(aoi = area.of.interest,
                        start.date = '2021-01-01',
                        end.date = '2021-12-31',
                        vegetation.index = 'ndvi')
}

}
\author{
Caio dos Santos and Fernando Miguez
}
