% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API-Local.R
\name{use_OpenMpp_local}
\alias{use_OpenMpp_local}
\title{OpenM++ Local API Connection}
\usage{
use_OpenMpp_local(url = Sys.getenv("OPENMPP_LOCAL_URL"), ...)
}
\arguments{
\item{url}{URL for making API requests. See \code{Details} for more
instructions.}

\item{...}{Not currently used.}
}
\value{
Nothing, invisibly. Behind-the-scenes, an instance of the
\code{OpenMppLocal} R6 class is created. These objects should not be accessed
directly by the user, instead, the package internally uses these
connections to communicate with the OpenM++ API.
}
\description{
Register a local connection to the OpenM++ Web Services (OMS) Application
Programming Interface (API). Currently, two different API connections
"local" and "remote" are available. Note that "local" and "remote"
describe where the API is running relative to the machine running the R
session. Those who use a machine running on their local network may use
a remote connection to connect with a cloud-based API, for example.
Users running OpenM++ locally or who are logged into a remote virtual
machine running OpenM++ will use the local API connection.
}
\details{
We recommend declaring the API URL in your global or
project-specific \code{.Renviron} file. For local and remote API connections,
set the following environment variable in your \code{.Renviron} files:
\itemize{
\item \code{OPENMPP_LOCAL_URL}: URL for a local API connection. Default is to use
http://localhost:4040.
}
}
\examples{
\dontrun{
use_OpenMpp_local()
}

}
