% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numspellr.R
\name{numspellr}
\alias{numspellr}
\title{Detect Numeric Persistence and Spell Patterns}
\usage{
numspellr(data, lang = c("indonesia", "english"), min_spell = 2, tol = NULL)
}
\arguments{
\item{data}{A numeric vector or a data.frame/tibble containing one or more numeric
variables. Non-numeric columns are ignored automatically.}

\item{lang}{Language for persistence status labels and interpretation text.
Must be either \code{"indonesia"} or \code{"english"}.}

\item{min_spell}{Minimum length (in periods) required for a sequence to be considered a
persistence spell. Default is \code{2}.}

\item{tol}{Optional numeric tolerance threshold for detecting stability.
If \code{NULL} (default), tolerance is determined automatically based on
variability of first differences.}
}
\value{
A data.frame with one row per numeric variable containing:

\describe{
\item{structure}{Detected data structure type.}
\item{id}{Variable identifier.}
\item{variable}{Variable name.}
\item{avg_spell}{Average persistence spell length.}
\item{median_spell}{Median persistence spell length.}
\item{max_spell}{Maximum persistence spell length.}
\item{stability_ratio}{Share of observations in stable spells.}
\item{elasticity_index}{Average relative change magnitude.}
\item{adjustment_frequency}{Frequency of meaningful adjustments.}
\item{spell_concentration}{Concentration index of persistence spells.}
\item{persistence_status}{Qualitative persistence category.}
\item{interpretation}{Plain-language interpretation suitable for policy analysis.}
}
}
\description{
\code{numspellr()} is a universal numeric persistence detector designed to
identify prolonged stability ("spells") and rigidity patterns in numeric
data. The function automatically detects numeric variables from various
data structures (numeric vectors or data frames) and computes persistence
metrics commonly used in rigidity and stickiness analysis.

The output includes interpretable measures such as average spell length,
stability ratio, elasticity, and adjustment frequency, accompanied by
plain-language interpretations suitable for policy and applied analysis.
}
\details{
The function identifies persistence spells as consecutive periods where
absolute changes fall below a tolerance threshold.

Metrics computed include:

\itemize{
\item \strong{avg_spell}: average duration of stable periods.
\item \strong{median_spell}: median duration of stability.
\item \strong{max_spell}: longest observed stable period.
\item \strong{stability_ratio}: proportion of observations belonging to spells.
\item \strong{elasticity_index}: average relative magnitude of changes.
\item \strong{adjustment_frequency}: share of periods with meaningful changes.
\item \strong{spell_concentration}: dominance of long spells over short ones.
}

Persistence status is classified into qualitative categories ranging from
highly flexible to highly rigid, with labels adapted to the selected language.
}
\examples{
x <- c(10, 10, 10, 11, 11, 11, 11, 12)
numspellr(x, lang = "english")

df <- data.frame(
  time = 1:8,
  value = c(5, 5, 5, 5, 6, 6, 6, 7)
)
numspellr(df, lang = "indonesia")

}
\references{
Caballero, R. J., & Engel, E. M. R. A. (1993).
Microeconomic adjustment hazards and aggregate dynamics.
\emph{Quarterly Journal of Economics}, 108(2), 359–383.

Nakamura, E., & Steinsson, J. (2008).
Five facts about prices: A reevaluation of menu cost models.
\emph{Quarterly Journal of Economics}, 123(4), 1415–1464.
}
\seealso{
\code{\link{diff}}, \code{\link{rle}}
}
\author{
Joko Nursiyono
}
