% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_nhdplus.R
\name{get_wb_outlet}
\alias{get_wb_outlet}
\title{Get Waterbody Outlet}
\usage{
get_wb_outlet(lake_id, network)
}
\arguments{
\item{lake_id}{integer COMID (or character permanent identifier for hi res) of lake.}

\item{network}{data.frame of network features containing wbareacomi, and Hydroseq}
}
\value{
sf data.frame with single record of network COMID
associated with most-downstream reach in the NHD Waterbody
}
\description{
Get Waterbody Outlet
}
\examples{
\donttest{

source(system.file("extdata/sample_data.R", package = "nhdplusTools"))

fline <- sf::read_sf(sample_data, "NHDFlowline_Network")
wtbdy <- sf::read_sf(sample_data, "NHDWaterbody")

lake_COMID <- wtbdy$COMID[wtbdy$GNIS_NAME=='Lake Mendota 254']

get_wb_outlet(13293262, fline)

}
}
