% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuroimagene_pkg.R
\name{neuroimaGene}
\alias{neuroimaGene}
\title{Main neuroimaGene query}
\usage{
neuroimaGene(
  gene_list,
  modality = "T1",
  atlas = "Desikan",
  mtc = "BH",
  nidps = NA,
  filename = NA,
  verbose = FALSE,
  vignette = FALSE
)
}
\arguments{
\item{gene_list}{List of genes to work as inputs. There are no defaults.}

\item{modality}{Neuroimaging modality for NIDP query. Defaults to T1 structural 
NIDPs. Other common options include 'dMRI' for diffusion MRI imaging and 'fMRI'
for fucntional MRI image results.}

\item{atlas}{Neuroimaging parcellation atlas for NIDP query. Defaults to 
Desikan structural atlas. Common T1 atlases include the 'DKT', and 'Destrieux'
cortical atlases and 'Subcortex' for freesurfer parcellation of subrotical regions. 
See package documentation or vignette for full list.}

\item{mtc}{Statistical multiple testing correction for NIDP query. This defaults 
to 'BH' for the Benjamini Hochberg False Discovery Rate. Other options include
'BF' for the bonferroni family wise error rate and 'nom' for nominal findings
at pvalue <= 0.05.}

\item{nidps}{optional user defined vector of target NIDPs to query. Specific 
NIDP names can be obtained from the listNIDPnames() function. Use of this
parameter overrides the multiple testing correction, returning all nominally 
significant findings.}

\item{filename}{optional user defined path/filename to which the script will
write the nueroimaGene output data table.}

\item{verbose}{print runtime messages to R console. Default to FALSE}

\item{vignette}{use for building vignette on installation. Default to FALSE}
}
\value{
a neuroimaGene object: data table with all significant associations between the user provided genes and the UKB NIDPs satisfying the multiple testing correction and atlas/modality/name filters.
}
\description{
Using a user supplied vector of genes (Ensembl ID's or HUGO names), this 
function queries the NeuroimaGene resource for all statistically significant
GReX-NIDP associations and returns all findings as a data.table.
}
\examples{
gene_list <- c('TRIM35', 'PROSER3', 'EXOSC6', 'PICK1', 'UPK1A', 'ESPNL', 'ZIC4')
ng <- neuroimaGene(gene_list, atlas = NA, mtc = 'BH', vignette = TRUE)

}
\keyword{neuroimaging}
