% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_transformations_mult.R
\name{tdir_trans}
\alias{tdir_trans}
\title{Transforms Truncated Dirichlet Samples To Real Line}
\usage{
tdir_trans(
  theta_mat,
  boundaries,
  mult_equal,
  nr_mult_equal,
  nr_mult_free,
  hyp_direction
)
}
\arguments{
\item{theta_mat}{matrix with samples from truncated Dirichlet density}

\item{boundaries}{list containing indices for upper and lower truncation boundaries}

\item{mult_equal}{multiplicative elements for each lower and upper bound of each inequality constrained parameter.}

\item{nr_mult_equal}{vector of multiplicative elements of collapsed parameters}

\item{nr_mult_free}{vector of multiplicative elements of free parameters}

\item{hyp_direction}{specifies whether the imposed inequality constrained imposes an increasing (i.e., 'smaller') or
decreasing (i.e., 'larger') trend}
}
\value{
matrix with transformed samples
}
\description{
Transforms samples from a truncated Dirichlet density to the real line using a stick-breaking algorithm.
This algorithm is suitable for mixtures of equality constrained parameters, inequality constrained parameters,
and free parameters
}
