% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_S3methods.R
\name{print.bmult}
\alias{print.bmult}
\title{print method for class \code{bmult}}
\usage{
\method{print}{bmult}(x, ...)
}
\arguments{
\item{x}{object of class \code{bmult} as returned from \code{\link{mult_bf_informed}} or \code{\link{binom_bf_informed}}}

\item{...}{additional arguments, currently ignored}
}
\value{
The print methods print the model specifications and descriptives and return nothing
}
\description{
Prints model specification
}
\examples{
# data
x <- c(3, 4, 10, 11)
n <- c(15, 12, 12, 12)
# priors
a <- c(1, 1, 1, 1)
b <- c(1, 1, 1, 1)
# informed hypothesis
factor_levels <- c('theta1', 'theta2', 'theta3', 'theta4')
Hr            <- c('theta1', '<',  'theta2', '<', 'theta3', '<', 'theta4')

## Binomial Case
out_binom  <- binom_bf_informed(x=x, n=n, Hr=Hr, a=a, b=b, niter=1e3,factor_levels, seed=2020)
out_binom
## Multinomial Case
out_mult  <- mult_bf_informed(x=x, Hr=Hr, a=a, niter=1e3,factor_levels, seed=2020)
out_mult
}
