% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-s4-class.R
\docType{class}
\name{MSAdata-class}
\alias{MSAdata-class}
\title{MSAdata S4 object}
\description{
S4 class that organizes the various data inputs for the MSA model. \code{MSAdata} simply inherits the slots from 6 component classes:
\code{Dmodel}, \code{Dstock}, \code{Dfishery}, \code{Dsurvey} \code{DCKMR}, and \code{Dtag}, where the \code{D}- prefix denotes an object for data inputs (or model configuration).
}
\details{
For convenience, most arrays and matrices have the associated dimensions in the variable name. For example, \code{Cobs_ymfr} represents
observed catch with the dimension following the underscore, following this template:

\tabular{ll}{
\code{y} \tab Year \cr
\code{m} \tab Season \cr
\code{a} \tab Age \cr
\code{r} \tab Region \cr
\code{f} \tab Fishery \cr
\code{i} \tab Index \cr
\code{s} \tab Stock
}
}
\section{Slots}{

\describe{
\item{\code{Dmodel}}{Class \linkS4class{Dmodel} containing parameters for model structure (number of years, ages, etc.)}

\item{\code{Dstock}}{Class \linkS4class{Dstock} containing stock parameters (growth, natural mortality, etc.)}

\item{\code{Dfishery}}{Class \linkS4class{Dfishery} containing fishery data (catch, size and stock composition, etc.)}

\item{\code{Dsurvey}}{Class \linkS4class{Dsurvey} containing survey data (indices of abundance)}

\item{\code{DCKMR}}{Class \linkS4class{DCKMR} containing genetic close-kin data}

\item{\code{Dtag}}{Class \linkS4class{Dtag} containing tagging data}

\item{\code{Dlabel}}{Class \linkS4class{Dlabel} containing names for various dimensions. Used for plotting.}

\item{\code{Misc}}{List for miscellaneous inputs as needed}
}}

\section{Slots inherited from Dmodel}{

\describe{
\item{\code{ny}}{Integer, number of years}
\item{\code{nm}}{Integer, number of seasons}
\item{\code{na}}{Integer, number of ages. The first age class is zero and the last age class (plus group is age \code{na - 1}).}
\item{\code{nl}}{Integer, number of length bins. Set to zero if lengths are not modeled.}
\item{\code{nr}}{Integer, number of spatial regions}
\item{\code{ns}}{Integer, number of stocks}
\item{\code{lbin}}{Vector of lower boundary of length bins. Length \code{nl + 1}}
\item{\code{lmid}}{Vector of midpoint of length bins. Length \code{nl}}
\item{\code{Fmax}}{Numeric, maximum allowable instantaneous fishing mortality rate (units of per season). Defaults to 3.}
\item{\code{y_phi}}{Integer, the year from which to obtain values of natural mortality and fecundity for the unfished stock-recruit replacement line (\code{phi}). Relevant if natural mortality or fecundity are time-varying. Defaults to 1.}
\item{\code{scale_s}}{Vector, length \code{ns}. Multiplicative scaling factor that informs relative stock size to aid parameter estimation. Larger values implies larger stocks. Default set to 1. See \code{\link[=make_parameters]{make_parameters()}}.}
\item{\code{nyinit}}{Integer, number of years of spool-up to calculate equilibrium unfished and starting conditions for the population model to account for seasonal and spatial dynamics. The numerical spool-up is not needed when both \code{nm = 1} and \code{nr = 1}, i.e., \code{nyinit = 1}. Otherwise, set to \code{2 * na} by default.}
\item{\code{condition}}{Character, either to specify the model estimates fishing mortality as a parameter (\code{"F"}, default) or equal to the catch (\code{"catch"}).}
\item{\code{nitF}}{Integer, number of iterations to solve Baranov catch equation from observed catch if \code{condition = "catch"}. Defaults to 5.}
\item{\code{y_Fmult_f}}{Integer vector by fleet, the year in which to directly estimate F. Choose a year/season/region combination when the catch is average relative to the time series. Only used if \code{condition = "F"}.}
\item{\code{m_Fmult_f}}{Integer vector by fleet, the season in which to directly estimate F. Choose a year/season/region combination when the catch is average relative to the time series. Only used if \code{condition = "F"}.}
\item{\code{r_Fmult_f}}{Integer vector by fleet, the region in which to directly estimate F. Choose a year/season/region combination when the catch is average relative to the time series. Only used if \code{condition = "F"}.}
\item{\code{pbc_rdev_ys}}{Numeric matrix, for the fraction of lognormal bias correction (\code{-0.5 * sd_r^2}) applied to the recruitment estimates in the model. Typically between 0-1, with default of 1.}
\item{\code{pbc_initrdev_as}}{Numeric matrix, for the fraction of lognormal bias correction (\code{-0.5 * sd_r^2}) applied to the initial abundance vector in the model. Typically between 0-1, with default of 1.}
\item{\code{prior}}{Character vector to be evaluated in the model to return the log prior for a parameter. See example in documentation for \link{prior}.}
\item{\code{nyret}}{Integer, number of recent years of data to remove from the likelihood for retrospective analysis (positive numbers). Default is zero.}
}
}

\section{Slots inherited from Dstock}{

\describe{
\item{\code{m_spawn}}{Integer, season of spawning. Defaults to 1. The progeny will enter the age structure in the same season.}
\item{\code{m_advanceage}}{Integer, season in which to advance age classes (corresponding to calendar year) to the next age class. Defaults to 1.}
\item{\code{len_ymas}}{Length-at-age. Only needed if \code{Dmodel@nl > 0} to fit length composition (you may want to calculate the growth at the middle of the time step). \code{\link[=calc_growth]{calc_growth()}} may be a helpful function.}
\item{\code{sdlen_ymas}}{Standard deviation in length-at-age}
\item{\code{LAK_ymals}}{Length-at-age probability array. If empty, values will be calculated by \code{\link[=check_data]{check_data()}} with \code{\link[=calc_LAK]{calc_LAK()}}.}
\item{\code{mat_yas}}{Proportion mature by age class. Ignored if maturity ogive is estimated, e.g., when fitting to close-kin genetic data.}
\item{\code{swt_ymas}}{Stock weight-at-age (at beginning of time step). See \code{\link[=calc_growth]{calc_growth()}} example.}
\item{\code{fec_yas}}{Fecundity, i.e., spawning output, of mature animals. Default uses stock weight at age.}
\item{\code{M_yas}}{Natural mortality. Instantaneous units per year. Ignored if M is estimated.}
\item{\code{SRR_s}}{Character vector of stock-recruit relationship by stock. See \code{SRR} argument in \code{\link[=calc_recruitment]{calc_recruitment()}} for options.}
\item{\code{delta_s}}{Fraction of season that elapses when spawning occurs, e.g., midseason spawning occurs when \code{delta_s = 0.5}. Default is zero.}
\item{\code{presence_rs}}{Logical matrix indicating presence/absence of stock \code{s} in region \code{r}. Used to constrain movement matrix.
Default is TRUE for all stocks and regions.}
\item{\code{natal_rs}}{The fraction of the mature stock \code{s} in region \code{r} that spawns at
time of spawning. See example. Default is 1 for all stocks and regions.}
}
}

\section{Slots inherited from Dfishery}{

\describe{
\item{\code{nf}}{Integer, number of fleets}
\item{\code{Cobs_ymfr}}{Total fishery catch}
\item{\code{Csd_ymfr}}{Lognormal standard deviation of the fishery catch. Only used if \code{Dmodel@condition = "F"}. Default of 0.01.}
\item{\code{fwt_ymafs}}{Fishery weight at age. Set to 1 when fleet catch is in units of abundance. Set to stock weight at age by default (values at beginning of time step).}
\item{\code{CAAobs_ymafr}}{Fishery catch at age composition}
\item{\code{CALobs_ymlfr}}{Fishery catch at length composition}
\item{\code{fcomp_like}}{Character, likelihood for the fishery composition data. See \code{type} argument of \code{\link[=like_comp]{like_comp()}} for options}
\item{\code{CAAN_ymfr}}{Sample size of the catch at age vector by season if using the multinomial or Dirichlet-multinomial likelihoods}
\item{\code{CALN_ymfr}}{Sample size of the catch at length vector by season if using the multinomial or Dirichlet-multinomial likelihoods}
\item{\code{CAAtheta_f}}{Catch at age dispersion parameter if using the Dirichlet-multinomial likelihood. Default set to 1.}
\item{\code{CALtheta_f}}{Catch at length dispersion parameter if using the Dirichlet-multinomial likelihood. Default set to 1.}
\item{\code{sel_block_yf}}{Index of dummy fleets to model time blocks of selectivity}
\item{\code{sel_f}}{Character vector of the functional form for selectivity. Choose between: \verb{"logistic_length", "dome_length", "logistic_age", "dome_age", "SB", "B"}}
\item{\code{Cinit_mfr}}{Equilibrium seasonal catch prior to the first year. One way to initialize the abundance at the start of the first year
in the model. Default of zero.}
\item{\code{SC_ymafrs}}{Stock composition data.}
\item{\code{SC_aa}}{Boolean matrix that aggregates age classes for the stock composition data. See example.}
\item{\code{SC_ff}}{Boolean matrix that aggregates fleets for the stock composition data. See example.}
\item{\code{SC_like}}{Character, likelihood for the stock composition data. See \code{type} argument of \code{\link[=like_comp]{like_comp()}} for options}
\item{\code{SCN_ymafr}}{Sample size of the stock composition vector if using the multinomial or Dirichlet-multinomial likelihoods}
\item{\code{SCtheta_f}}{Stock composition dispersion parameter if using the Dirichlet-multinomial likelihood. Default set to 1.}
\item{\code{SCstdev_ymafrs}}{Stock composition standard deviation if using the lognormal likelihood. Default set to 0.1.}
}
}

\section{Slots inherited from Dsurvey}{

\describe{
\item{\code{ni}}{Integer, number of indices of abundance. Zero is possible.}
\item{\code{Iobs_ymi}}{Observed indices}
\item{\code{Isd_ymi}}{Lognormal standard deviation of the observed indices}
\item{\code{unit_i}}{Character vector, units of the index. Set to \code{"B"} to use stock weight at age (default) or \code{"N"} for abundance (numbers).}
\item{\code{IAAobs_ymai}}{Array, survey age composition}
\item{\code{IALobs_ymli}}{Array, survey length composition}
\item{\code{icomp_like}}{Character, likelihood for the composition data. See \code{\link[=like_comp]{like_comp()}} for options}
\item{\code{IAAN_ymi}}{Array, sample size of the index age composition by season if using the multinomial or Dirichlet-multinomial likelihoods}
\item{\code{IALN_ymi}}{Array, sample size of the index length composition by season if using the multinomial or Dirichlet-multinomial likelihoods}
\item{\code{IAAtheta_i}}{Numeric vector, survey age composition dispersion parameter if using the Dirichlet-multinomial likelihood}
\item{\code{IALtheta_i}}{Numeric vector, index length composition dispersion parameter if using the Dirichlet-multinomial likelihood}
\item{\code{samp_irs}}{Boolean array that specifies the regions and stocks sampled by the index. \code{samp[i, r, s]} indicates whether index \code{i} operates in region \code{r} and catches stock \code{s}.}
\item{\code{sel_i}}{Character vector, functional forms for selectivity. See \code{"type"} argument in \code{\link[=conv_selpar]{conv_selpar()}} for options.}
\item{\code{delta_i}}{Numeric vector, The elapsed fraction of time in the seasonal time step (between 0 - 1) when the index samples the population. Set to a negative number (-1) to sample over the duration of the timestep, i.e., \code{(1 - exp(-Z))/Z}.}
}
}

\section{Slots inherited from DCKMR}{

\describe{
\item{\code{POP_s}}{A list by stock of data frames for parent-offspring pairs. Each row in the data frame corresponds to a "sampling unit" defined by the columns:
\tabular{ll}{
\code{a} \tab Capture year of parent \cr
\code{t} \tab Age at capture of parent \cr
\code{y} \tab Birth year of offspring \cr
\code{n} \tab Number of pairwise comparisons \cr
\code{m} \tab Number of POPs \cr
}
}
\item{\code{HSP_s}}{A list by stock of data frames for half-sibling pairs. Each row in the data frame corresponds to a "sampling unit" defined by the columns:
\tabular{ll}{
\code{yi} \tab Birth year of older sibling \cr
\code{yj} \tab Birth year of younger sibling \cr
\code{n} \tab Number of pairwise comparisons \cr
\code{m} \tab Number of HSPs
}
}
\item{\code{CKMR_like}}{Character, likelihood for the POP and HSP sampling units. See \code{type} argument in \code{\link[=like_CKMR]{like_CKMR()}} for options.}
}
}

\section{Slots inherited from Dtag}{

\describe{
\item{\code{tag_ymarrs}}{Array. Number of tags that move between regions. Informs movement matrices of stocks between time steps.}
\item{\code{tag_ymars}}{Array. Number of tags distributed among regions. Informs stock distribution (within time step).}
\item{\code{tag_yy}}{Boolean matrix that aggregates years for the tag data. Only used for the tag movement array \code{tag_ymarrs}.}
\item{\code{tag_aa}}{Boolean matrix that aggregates ages for the tag data.}
\item{\code{tag_like}}{Character. Likelihood for the tagging data, either the vector of proportions by region of origin for \code{tag_ymarrs}, or
by region of stock distribution for \code{tag_ymars}. See \code{type} argument of \code{\link[=like_comp]{like_comp()}} for options}
\item{\code{tagN_ymars}}{Array. Sample size of the tag movement vectors if using the multinomial or Dirichlet-multinomial likelihoods.}
\item{\code{tagN_ymas}}{Array. Sample size of the tag distribution vectors if using the multinomial or Dirichlet-multinomial likelihoods.}
\item{\code{tagtheta_s}}{Array. Tag dispersion parameter (by stock) if using the Dirichlet-multinomial likelihoods. Default set to 1.}
\item{\code{tagstdev_s}}{Array. Tag standard deviation (by stock) if using the lognormal likelihood. Default set to 0.1.}
}
}

\section{Slots inherited from Dlabel}{

\describe{
\item{\code{year}}{Vector of years. Length \code{Dmodel@ny}}
\item{\code{season}}{Vector of season names. Length \code{Dmodel@nm}}
\item{\code{age}}{Vector of ages. Length \code{Dmodel@na}}
\item{\code{region}}{Vector of region names. Length \code{Dmodel@nr}}
\item{\code{stock}}{Vector of stock names. Length \code{Dmodel@ns}}
\item{\code{fleet}}{Vector of fleet names. Length \code{Dfishery@nf}}
\item{\code{index}}{Vector of index of abundance names. Length \code{Dsurvey@ni}}
}
}

\examples{
# Set natal_rs matrix so that the spawning output of stock 1 is
# calculated from mature animals present in regions 1, 2.
# Similarly for stock 2, spawning output from areas 2 and 3.
nr <- 4
ns <- 2
natal_rs <- matrix(0, nr, ns)
natal_rs[1:2, 1] <- natal_rs[2:3, 2] <- 1

# Aggregate stock composition for ages 1-4 and 5-10 across all fleets
na <- 10
na_SC <- 2
SC_aa <- matrix(0, na_SC, na) # Assumes dim(SC_ymafrs)[3] = na_SC
SC_aa[1, 1:4] <- SC_aa[2, 5:10] <- 1

nf <- 3
nf_SC <- 1
SC_ff <- matrix(1, nf_SC, nf) # Assumes dim(SC_ymafrs)[4] <- nf_SC

}
\seealso{
\link{MSAdata-class} \code{\link[=check_data]{check_data()}} \link{Dmodel-class} \link{Dstock-class} \link{Dfishery-class} \link{Dsurvey-class} \link{DCKMR-class} \link{Dtag-class}
}
\keyword{MSAdata}
