% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-s4-class.R
\docType{class}
\name{Dtag-class}
\alias{Dtag-class}
\title{Dtag S4 object}
\description{
S4 class that organizes the various data inputs for the MSA model. \code{MSAdata} simply inherits the slots from 6 component classes:
\code{Dmodel}, \code{Dstock}, \code{Dfishery}, \code{Dsurvey} \code{DCKMR}, and \code{Dtag}, where the \code{D}- prefix denotes an object for data inputs (or model configuration).
}
\details{
For convenience, most arrays and matrices have the associated dimensions in the variable name. For example, \code{Cobs_ymfr} represents
observed catch with the dimension following the underscore, following this template:

\tabular{ll}{
\code{y} \tab Year \cr
\code{m} \tab Season \cr
\code{a} \tab Age \cr
\code{r} \tab Region \cr
\code{f} \tab Fishery \cr
\code{i} \tab Index \cr
\code{s} \tab Stock
}
}
\section{Slots inherited from Dtag}{

\describe{
\item{\code{tag_ymarrs}}{Array. Number of tags that move between regions. Informs movement matrices of stocks between time steps.}
\item{\code{tag_ymars}}{Array. Number of tags distributed among regions. Informs stock distribution (within time step).}
\item{\code{tag_yy}}{Boolean matrix that aggregates years for the tag data. Only used for the tag movement array \code{tag_ymarrs}.}
\item{\code{tag_aa}}{Boolean matrix that aggregates ages for the tag data.}
\item{\code{tag_like}}{Character. Likelihood for the tagging data, either the vector of proportions by region of origin for \code{tag_ymarrs}, or
by region of stock distribution for \code{tag_ymars}. See \code{type} argument of \code{\link[=like_comp]{like_comp()}} for options}
\item{\code{tagN_ymars}}{Array. Sample size of the tag movement vectors if using the multinomial or Dirichlet-multinomial likelihoods.}
\item{\code{tagN_ymas}}{Array. Sample size of the tag distribution vectors if using the multinomial or Dirichlet-multinomial likelihoods.}
\item{\code{tagtheta_s}}{Array. Tag dispersion parameter (by stock) if using the Dirichlet-multinomial likelihoods. Default set to 1.}
\item{\code{tagstdev_s}}{Array. Tag standard deviation (by stock) if using the lognormal likelihood. Default set to 0.1.}
}
}

\seealso{
\link{MSAdata-class} \code{\link[=check_data]{check_data()}} \link{Dmodel-class} \link{Dstock-class} \link{Dfishery-class} \link{Dsurvey-class} \link{DCKMR-class} \link{Dtag-class}
}
