% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-s4-class.R
\docType{class}
\name{Dstock-class}
\alias{Dstock-class}
\title{Dstock S4 object}
\description{
S4 class that organizes the various data inputs for the MSA model. \code{MSAdata} simply inherits the slots from 6 component classes:
\code{Dmodel}, \code{Dstock}, \code{Dfishery}, \code{Dsurvey} \code{DCKMR}, and \code{Dtag}, where the \code{D}- prefix denotes an object for data inputs (or model configuration).
}
\details{
For convenience, most arrays and matrices have the associated dimensions in the variable name. For example, \code{Cobs_ymfr} represents
observed catch with the dimension following the underscore, following this template:

\tabular{ll}{
\code{y} \tab Year \cr
\code{m} \tab Season \cr
\code{a} \tab Age \cr
\code{r} \tab Region \cr
\code{f} \tab Fishery \cr
\code{i} \tab Index \cr
\code{s} \tab Stock
}
}
\section{Slots inherited from Dstock}{

\describe{
\item{\code{m_spawn}}{Integer, season of spawning. Defaults to 1. The progeny will enter the age structure in the same season.}
\item{\code{m_advanceage}}{Integer, season in which to advance age classes (corresponding to calendar year) to the next age class. Defaults to 1.}
\item{\code{len_ymas}}{Length-at-age. Only needed if \code{Dmodel@nl > 0} to fit length composition (you may want to calculate the growth at the middle of the time step). \code{\link[=calc_growth]{calc_growth()}} may be a helpful function.}
\item{\code{sdlen_ymas}}{Standard deviation in length-at-age}
\item{\code{LAK_ymals}}{Length-at-age probability array. If empty, values will be calculated by \code{\link[=check_data]{check_data()}} with \code{\link[=calc_LAK]{calc_LAK()}}.}
\item{\code{mat_yas}}{Proportion mature by age class. Ignored if maturity ogive is estimated, e.g., when fitting to close-kin genetic data.}
\item{\code{swt_ymas}}{Stock weight-at-age (at beginning of time step). See \code{\link[=calc_growth]{calc_growth()}} example.}
\item{\code{fec_yas}}{Fecundity, i.e., spawning output, of mature animals. Default uses stock weight at age.}
\item{\code{M_yas}}{Natural mortality. Instantaneous units per year. Ignored if M is estimated.}
\item{\code{SRR_s}}{Character vector of stock-recruit relationship by stock. See \code{SRR} argument in \code{\link[=calc_recruitment]{calc_recruitment()}} for options.}
\item{\code{delta_s}}{Fraction of season that elapses when spawning occurs, e.g., midseason spawning occurs when \code{delta_s = 0.5}. Default is zero.}
\item{\code{presence_rs}}{Logical matrix indicating presence/absence of stock \code{s} in region \code{r}. Used to constrain movement matrix.
Default is TRUE for all stocks and regions.}
\item{\code{natal_rs}}{The fraction of the mature stock \code{s} in region \code{r} that spawns at
time of spawning. See example. Default is 1 for all stocks and regions.}
}
}

\examples{
# Set natal_rs matrix so that the spawning output of stock 1 is
# calculated from mature animals present in regions 1, 2.
# Similarly for stock 2, spawning output from areas 2 and 3.
nr <- 4
ns <- 2
natal_rs <- matrix(0, nr, ns)
natal_rs[1:2, 1] <- natal_rs[2:3, 2] <- 1

}
\seealso{
\link{MSAdata-class} \code{\link[=check_data]{check_data()}} \link{Dmodel-class} \link{Dstock-class} \link{Dfishery-class} \link{Dsurvey-class} \link{DCKMR-class} \link{Dtag-class}
}
