% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_control.R
\name{control}
\alias{control}
\title{Control Algorithm Behavior}
\description{
The \code{control} argument is a mandatory list used to customize and manage
   various aspects of the iterative process, covering everything from 
   optimization settings to model configuration.
}
\section{Class}{
 
\code{control [List]}
}

\section{Note}{
 
 Different estimation methods require different slots. However, there is no 
   need to worry if you set unnecessary slots, as this will not affect the 
   execution.
}

\section{1. Likelihood Based Inference (LBI)}{
 
\itemize{
   \item \code{sample [int]} 
   
         This parameter denotes the quantity of simulated data generated 
         during the parameter recovery process.
         
   \item \code{iter [int]} 
   
         This parameter defines the maximum number of iterations. The 
         iterative process will stop when this value is reached. The default 
         value is \code{10}. It is recommended that you set this value to at 
         least \code{100} for formal fitting procedures.
         
   \item \code{pars [NumericVector]} 
   
         Some algorithms require the specification of initial iteration 
         values. If this value is left as the default NA, the iteration will 
         commence with an initial value set to the lower bound of the 
         estimate plus \code{0.01}.
         
   \item \code{dash [Numeric]} 
   
         To prevent the optimal parameter estimates from converging to 
         boundary values when the number of iterations is insufficient, a 
         small value is added to the lower bound and subtracted from the 
         upper bound. 
         
         For instance, if the input parameter bounds are \code{(0, 1)}, 
         the actual bounds used for fitting will be \code{[0.00001, 0.99999]}. 
         This design prevents the occurrence of Infinite values.
         
   \item \code{size [int]} 
   
         Some algorithms, such as Genetic Algorithms (\code{GA}), require the 
         specification of initial population values. For the definition of 
         the population, users may refer to the relevant documentation on 
         evolutionary algorithms. The default value is consistent with the 
         standard default in \code{GA}, which is \code{50}.
         
   \item \code{seed [int]} 
   
         The random seed controls the reproducibility of each iteration. 
         Specifically, it determines how the algorithm package generates 
         “random” input parameters when searching for the optimal parameters. 
         Fixing the seed ensures that the optimal parameters found are the 
         same in every run. The default value is \code{123}.
         
   \item \code{core [int]} 
   
         Since the parameter fitting process for individual subjects is 
         independent, this procedure can be accelerated using CPU 
         parallelism. This argument specifies the number of subjects to 
         be fitted simultaneously (the number of parallel threads), 
         with the default set to \code{1}. If the user wishes to speed up the 
         fitting, they can increase the number of cores appropriately based 
         on their system specifications.
}
   
\subsection{1.1 Maximum Likelihood Estimation (MLE)}{

\itemize{
   \item Nothing special
}
}

\subsection{1.2 Maximum A Posteriori (MAP)}{

\itemize{
   \item \code{diff [double]} 
   
         In the Expectation–Maximization with Maximum A Posteriori algorithm 
         (EM-MAP), after estimating the optimal parameters for all subjects 
         in each iteration, the posterior distribution of each free 
         parameter is calculated, followed by continuous refinement of the 
         prior distribution. The process stops when the change in the 
         log-posterior value is less than the \code{diff}, which defaults 
         to \code{0.001}.
         
   \item \code{patience [int]} 
   
         Given that the Expectation–Maximization with Maximum A Posteriori 
         (EM-MAP) process can be time-consuming and often encounters 
         non-convergence issues—for instance, when the log-posterior 
         oscillates around a certain value—the patience parameter is used to 
         manage early termination.Specifically, patience is incremented by 
         1 when the current result is better than the best previous result, 
         and decremented by 1 when it is worse. The iteration is prematurely 
         terminated when the patience count reaches zero.
         
}
}
}

\section{2. Simulation Based Inference (SBI)}{
 
\itemize{
   \item \code{sample [int]} 
   
         This parameter denotes the quantity of simulated data generated 
         during the parameter recovery process.
         
   \item \code{train [int]} 
   
         This parameter is used to specify the quantity of simulated data 
         utilized when training the Approximate Bayesian Computation (ABC) or 
         Recurrent Neural Network (RNN) models.
         
   \item \code{scope [Character]} 
   
         This parameter can be defined as \code{individual} or \code{shared}. 
         The former indicates that a separate Approximate Bayesian 
         Computation (ABC) or Recurrent Neural Network (RNN) model is 
         trained for each dataset, while the latter means that only one 
         Approximate Bayesian Computation (ABC) or Recurrent Neural Network 
         (RNN) model is trained and shared across all datasets. In the 
         context of the \code{rcv_d} function, the default setting is 
         \code{"shared"}, whereas in \code{fit_p}, the default is 
         \code{"individual"}. 
         
   \item \code{seed [int]} 
   
         When performing parameter recovery using Simulation-Based Inference 
         (SBI) estimation methods, two sets of simulated data are involved: 
         one used to generate the data for recovery, and another used to 
         train the Approximate Bayesian Computation (ABC) or Recurrent 
         Neural Network (RNN) models. To guarantee the independence of these 
         two datasets, the seed for generating the training data is 
         automatically multiplied by 2.
         
   \item \code{core [int]} 
   
         Since the parameter fitting process for individual subjects is 
         independent, this procedure can be accelerated using CPU 
         parallelism. This argument specifies the number of subjects to 
         be fitted simultaneously (the number of parallel threads), 
         with the default set to \code{1}. If the user wishes to speed up the 
         fitting, they can increase the number of cores appropriately based 
         on their system specifications. When \code{estimate = "RNN"}, since 
         model training is typically handled by the GPU, setting 
         \code{core > 1} will only accelerate the generation of simulated 
         data.
}

\subsection{2.1 Approximate Bayesian Computation (ABC)}{

\itemize{
         
   \item \code{tol [double]} 
   
         This parameter, aka tolerance, controls how strict the Approximate 
         Bayesian Computation (ABC) algorithm is when selecting good 
         simulated data. It sets the acceptance rate. For example, setting 
         \code{tol = 0.1} (the default) means only the 10 percent of 
         simulated data that is closest to your actual data is used. 
         
}
}

\subsection{2.2 Recurrent Neural Network (RNN)}{

\itemize{
   \item \code{info [CharacterVector]} 
   
         The Recurrent Neural Network (RNN) needs to find the mapping 
         relationship between the dataset and the free parameters. To 
         minimize the time required for this process, we should only include 
         useful information in the input dataset. The \code{info} parameter 
         accepts a character vector which represents the amount of 
         information (i.e., the specific columns) you deem necessary for 
         training the Recurrent Neural Network (RNN) model. By default, only 
         the \code{colnames$object} and \code{colnames$action} columns are 
         included as input.
         
   \item \code{layer [Character]} 
   
         Recurrent Neural Networks (RNNs) are neural networks where the 
         sequence order is meaningful. Currently, the package supports two 
         types of recurrent layers: Gated Recurrent Unit (GRU) and Long 
         Short-Term Memory (LSTM). You can specify either of these as the 
         recurrent layer in your model.
         
   \item \code{units [int]} 
   
         The number of neurons (or units) in the Recurrent Layer 
         (GRU or LSTM). Conceptually, this parameter represents the memory 
         capacity and complexity of the network; it dictates how much 
         information about the sequential trials the model can store and 
         process.
         
   \item \code{batch_size [int]} 
   
         The number of samples processed before the model's parameters are 
         updated. Think of this as the size of a study group; the model 
         reviews this batch of data before adjusting its internal weights. 
         A larger batch size speeds up calculation but may lead to less 
         optimal convergence.
         
   \item \code{epochs [int]} 
   
         The number of times the learning algorithm will work through the 
         entire training dataset. This is equivalent to running through the 
         "textbook" multiple times. Each epoch means the model has seen 
         every training sample once. More epochs allow for more training but 
         increase the risk of overfitting.
         
}
}
}

\section{Example}{
 
\preformatted{ # default values
 control = list(
   # LBI
   pars = NA,
   dash = 1e-5,
   iter = 10,
   size = 50,
   seed = 123,
   core = 1,
   # MLE
   ...,
   # MAP
   diff = 0.001,
   patience = 10,
   # SBI
   sample = 100, 
   train = 1000, 
   scope = "individual", 
   # ABC
   tol = 0.1,
   # 
   info = c(colnames$object, colnames$action), 
   layer = "GRU", 
   units = 128, 
   batch_size = 10, 
   epochs = 100
 )
}
}

