% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish_collection.R
\name{publish_collection}
\alias{publish_collection}
\title{Publish a Collection to OpenML}
\usage{
publish_collection(
  ids,
  name,
  desc,
  main_entity_type = "task",
  alias = NULL,
  api_key = NULL,
  test_server = test_server_default()
)
}
\arguments{
\item{ids}{(\code{integer()})\cr
The IDs to include in the collection.
Depending on the main entity tupe, these can be task or run IDs.}

\item{name}{(\code{character(1)})\cr
The name for the collection.}

\item{desc}{(\code{character(1)})\cr
The description of the collection.}

\item{main_entity_type}{(\code{character(1)})\cr
The main entity type of the collection. Can be either "task" or "run".}

\item{alias}{(\code{character(1)})\cr
The alias for the collection.}

\item{api_key}{(\code{character(1)})
The API key to perform the action, if left NULL it first tries the "mlr3oml.api_key" R option and
then the environment variable \code{OPENMLAPIKEY}.

In case \code{test_server} is TRUE (only relevant for developers) the test server API key is used, i.e. first the option
"mlr3oml.test_api_key" and then the environment variable \code{TESTOPENMLAPIKEY}.}

\item{test_server}{(\code{character(1)})\cr
Whether to use the OpenML test server or public server.
Defaults to value of option \code{"mlr3oml.test_server"}, or \code{FALSE} if not set.}
}
\description{
Publish a collection to OpenML
This can also be achieved through the \href{https://www.openml.org}{website}.
}
