% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percent_missing.R
\name{percent_missing}
\alias{percent_missing}
\title{Column-wise missingness percentages}
\usage{
percent_missing(df, grouping_cols = NULL, exclude_cols = NULL)
}
\arguments{
\item{df}{A valid R `object` for which the percentage of missing values is 
required.}

\item{grouping_cols}{A character vector. If supplied, one can provide the columns by which to group the
data.}

\item{exclude_cols}{A character vector indicating columns to exclude when 
returning results.}
}
\value{
An object of the same class as x showing the percentage of missing 
values.
}
\description{
A convenient way to obtain percent missingness column-wise.
}
\examples{
test <- data.frame(ID= c("A","B","A","B","A","B","A"), 
Vals = c(NA,25,34,NA,67,NA,45))
percent_missing(test,grouping_cols = "ID")
percent_missing(airquality)
percent_missing(airquality,exclude_cols = c("Day","Temp"))
}
