% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{genetic-mapping-functions}
\alias{genetic-mapping-functions}
\alias{mf_k}
\alias{mf_h}
\alias{mf_m}
\alias{imf_k}
\alias{imf_h}
\alias{imf_m}
\title{Genetic Mapping Functions}
\usage{
mf_k(d)

mf_h(d)

mf_m(d)

imf_k(r)

imf_h(r)

imf_m(r)
}
\arguments{
\item{d}{Numeric or numeric vector, representing genetic distances in centiMorgans (cM) for direct functions (mf_k, mf_h, mf_m).}

\item{r}{Numeric or numeric vector, representing recombination fractions for inverse functions (imf_k, imf_h, imf_m).}
}
\description{
These functions facilitate the conversion between recombination fractions (r) and genetic distances (d) 
using various mapping models. The functions starting with `mf_` convert recombination fractions to genetic distances,
while those starting with `imf_` convert genetic distances back into recombination fractions.
}
\details{
The `mf_` prefixed functions apply different models to convert recombination fractions into genetic distances:
\itemize{
  \item \code{mf_k}: Kosambi mapping function.
  \item \code{mf_h}: Haldane mapping function.
  \item \code{mf_m}: Morgan mapping function.
}
The `imf_` prefixed functions convert genetic distances back into recombination fractions:
\itemize{
  \item \code{imf_k}: Inverse Kosambi mapping function.
  \item \code{imf_h}: Inverse Haldane mapping function.
  \item \code{imf_m}: Inverse Morgan mapping function.
}
}
\references{
Kosambi, D.D. (1944). The estimation of map distances from recombination values. Ann Eugen., 12, 172-175.
Haldane, J.B.S. (1919). The combination of linkage values, and the calculation of distances between the loci of linked factors. J Genet, 8, 299-309.
Morgan, T.H. (1911). Random segregation versus coupling in Mendelian inheritance. Science, 34(873), 384.
}
\keyword{genetics}
