% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codes.R
\name{code_info}
\alias{code_info}
\alias{code_info.numeric}
\alias{code_info.character}
\title{Retrieve states or districts using codes}
\usage{
code_info(code11, sortAndRemoveDuplicates = FALSE)

\method{code_info}{numeric}(code11, sortAndRemoveDuplicates = FALSE)

\method{code_info}{character}(code11, sortAndRemoveDuplicates = FALSE)
}
\arguments{
\item{code11}{A one to three digit, either \code{numeric}
or \code{character}, vector of odes for which to look up states or districts.
States have a two digit code and districts have a five digit code (where
the first 2 numbers pertain to the state).}

\item{sortAndRemoveDuplicates}{Whether or not to sort the output and remove
duplicates. By default, the output will be returned in the order of
the values provided to the \code{codes} parameter. Set this parameter to \code{TRUE}
to return the output sorted by codes with a single instance of each code.}
}
\value{
A data frame with the states or counties and the associated codes.

 If `codes` is omitted, the data frame containing all available states is
 returned.
}
\description{
Retrieve states or districts using codes
}
\examples{
code_info(2)
code_info("02")
code_info(c("02", "03", "04"))

code_info(19335)
code_info(c("19335", "19337"), sortAndRemoveDuplicates = TRUE)

}
\seealso{
[codes()]
}
