% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapboxgl.R
\name{mapboxgl}
\alias{mapboxgl}
\title{Initialize a Mapbox GL Map}
\usage{
mapboxgl(
  style = NULL,
  center = c(0, 0),
  zoom = 0,
  bearing = 0,
  pitch = 0,
  projection = "globe",
  parallels = NULL,
  access_token = NULL,
  bounds = NULL,
  width = "100\%",
  height = NULL,
  ...
)
}
\arguments{
\item{style}{The Mapbox style to use.}

\item{center}{A numeric vector of length 2 specifying the initial center of the map.}

\item{zoom}{The initial zoom level of the map.}

\item{bearing}{The initial bearing (rotation) of the map, in degrees.}

\item{pitch}{The initial pitch (tilt) of the map, in degrees.}

\item{projection}{The map projection to use (e.g., "mercator", "globe").}

\item{parallels}{A vector of two numbers representing the standard parallels of the projection.  Only available when the projection is "albers" or "lambertConformalConic".}

\item{access_token}{Your Mapbox access token.}

\item{bounds}{The bounding box to fit the map to. Accepts one of the following:
\itemize{
\item \code{sf} object;
\item output of \code{st_bbox()};
\item unnamed numeric vector of the form \code{c(xmin, ymin, xmax, ymax)}.
}}

\item{width}{The width of the output htmlwidget.}

\item{height}{The height of the output htmlwidget.}

\item{...}{Additional named parameters to be passed to the Mapbox GL JS Map.
See the Mapbox GL JS documentation for a full list of options:
\url{https://docs.mapbox.com/mapbox-gl-js/api/map/#map-parameters}.
Common options include:
\itemize{
\item \code{minZoom} / \code{maxZoom}: Minimum and maximum zoom levels (0-24).
\item \code{maxBounds}: Restrict panning to a bounding box, specified as
\code{list(c(sw_lng, sw_lat), c(ne_lng, ne_lat))}.
\item \code{dragRotate}: If \code{FALSE}, disables rotation via mouse drag (default \code{TRUE}).
\item \code{touchZoomRotate}: If \code{FALSE}, disables pinch-to-rotate on touch (default \code{TRUE}).
\item \code{scrollZoom}: If \code{FALSE}, disables scroll wheel zoom (default \code{TRUE}).
}}
}
\value{
An HTML widget for a Mapbox GL map.
}
\description{
Initialize a Mapbox GL Map
}
\examples{
\dontrun{
# Basic map
mapboxgl(projection = "globe")

# Constrained map with zoom limits and disabled rotation
mapboxgl(
  bounds = my_sf_object,
  minZoom = 5,
  maxZoom = 12,
  dragRotate = FALSE,
  touchZoomRotate = FALSE
)
}
}
