% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{convert_load_units}
\alias{convert_load_units}
\title{Convert Load Units to Tons}
\usage{
convert_load_units(load_values, from_unit)
}
\arguments{
\item{load_values}{Numeric vector of load values}

\item{from_unit}{Character. Input unit: "kg", "lbs", "pounds", "tons"}
}
\value{
Numeric vector of loads in US tons
}
\description{
Convert loads from various units to US tons
}
\examples{
# Convert from kilograms to tons
kg_loads <- c(1000, 2000, 3000)
tons_loads <- convert_load_units(kg_loads, "kg")

# Convert from pounds to tons
lbs_loads <- c(5000, 10000, 15000)
tons_loads <- convert_load_units(lbs_loads, "lbs")
}
