% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_calc.R
\name{cor_calc}
\alias{cor_calc}
\title{Correlation Matrix Estimation with Support for Multiple Correlation Types}
\usage{
cor_calc(
  data,
  ordered = FALSE,
  missing_handling = "two-step-em",
  nimp = 20,
  imp_method = "pmm",
  maxit = 10,
  ...
)
}
\arguments{
\item{data}{Data frame or matrix containing the variables for which the
correlation matrix is to be computed. May include missing values.}

\item{ordered}{Logical vector indicating whether each variable in \code{data}
should be treated as ordered categorical when computing the correlation
matrix. If a single logical value is supplied, it is recycled to all
variables.}

\item{missing_handling}{Character string specifying how the correlation
matrix is estimated from \code{data} in the presence of missing values. Possible
values are:
\describe{
\item{\code{"two-step-em"}}{Uses a classical EM algorithm to estimate the
correlation matrix from \code{data}.}
\item{\code{"stacked-mi"}}{Uses stacked multiple imputation to estimate the
correlation matrix from \code{data}.}
\item{\code{"pairwise"}}{Uses pairwise deletion to compute correlations from
\code{data}.}
\item{\code{"listwise"}}{Uses listwise deletion to compute correlations from
\code{data}.}
}}

\item{nimp}{Number of imputations (default: 20) to be used when
\code{missing_handling = "stacked-mi"}.}

\item{imp_method}{Character string specifying the imputation method to be
used when \code{missing_handling = "stacked-mi"} (default: \code{"pmm"} - predictive
mean matching).}

\item{maxit}{Maximum number of iterations for the imputation algorithm when
\code{missing_handling = "stacked-mi"} (default: 10).}

\item{...}{Further arguments passed to internal functions.}
}
\value{
A list containing:
\describe{
\item{mat}{Estimated correlation matrix.}
\item{means}{Vector of estimated means. If any variable is treated as ordered,
means is returned as NULL.}
\item{cor_method}{A matrix indicating the correlation method used for each
variable pair.}
\item{args}{List of settings used in the correlation estimation.}
}
}
\description{
Computes a correlation matrix from raw data while accounting for missing
values through several missing-data handling strategies. Supports different
correlation types based on whether variables are treated as ordered.
}
\details{
Correlations are computed pairwise:
\itemize{
\item Polychoric correlations for two ordered variables,
\item Polyserial correlations for one ordered and one continuous variable,
\item Pearson correlations for two continuous variables.
}

Treating variables as ordered requires the missing handling method to be either
\code{"stacked-mi"} or \code{"listwise"}

Means are computed whenever Pearson correlations are used. If any variable
is treated as ordered, \code{means} is returned as NULL.
}
\examples{
# Estimate correlation matrix from full data set
result <- cor_calc(data = mantar_dummy_full_cont,
                   ordered = FALSE)

# View estimated correlation matrix and methods used
result$mat
result$cor_method

# Estimate correlation matrix for data set with missings
result_mis <- cor_calc(data = mantar_dummy_mis_cont,
                      ordered = FALSE,
                      missing_handling = "two-step-em")

# View estimated correlation matrix and methods used
result_mis$mat
result_mis$cor_method
}
