% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm-extract.R
\name{llm_extract}
\alias{llm_extract}
\alias{llm_vec_extract}
\title{Extract entities from text}
\usage{
llm_extract(
  .data,
  col,
  labels,
  expand_cols = FALSE,
  additional_prompt = "",
  pred_name = ".extract"
)

llm_vec_extract(x, labels = c(), additional_prompt = "", preview = FALSE)
}
\arguments{
\item{.data}{A \code{data.frame} or \code{tbl} object that contains the text to be
analyzed}

\item{col}{The name of the field to analyze, supports \code{tidy-eval}}

\item{labels}{A vector with the entities to extract from the text}

\item{expand_cols}{If multiple \code{labels} are passed, this is a flag that
tells the function to create a new column per item in \code{labels}. If
\code{labels} is a named vector, this function will use those names as the
new column names, if not, the function will use a sanitized version of
the content as the name.}

\item{additional_prompt}{Inserts this text into the prompt sent to the LLM}

\item{pred_name}{A character vector with the name of the new column where the
prediction will be placed}

\item{x}{A vector that contains the text to be analyzed}

\item{preview}{It returns the R call that would have been used to run the
prediction. It only returns the first record in \code{x}. Defaults to \code{FALSE}
Applies to vector function only.}
}
\value{
\code{llm_extract} returns a \code{data.frame} or \code{tbl} object.
\code{llm_vec_extract} returns a vector that is the same length as \code{x}.
}
\description{
Use a Large Language Model (LLM) to extract specific entity, or entities,
from the provided text
}
\examples{
\donttest{
library(mall)

data("reviews")

llm_use("ollama", "llama3.2", seed = 100, .silent = TRUE)

# Use 'labels' to let the function know what to extract
llm_extract(reviews, review, labels = "product")

# Use 'pred_name' to customize the new column's name
llm_extract(reviews, review, "product", pred_name = "prod")

# Pass a vector to request multiple things, the results will be pipe delimeted
# in a single column
llm_extract(reviews, review, c("product", "feelings"))

# To get multiple columns, use 'expand_cols'
llm_extract(reviews, review, c("product", "feelings"), expand_cols = TRUE)

# Pass a named vector to set the resulting column names
llm_extract(
  .data = reviews,
  col = review,
  labels = c(prod = "product", feels = "feelings"),
  expand_cols = TRUE
)

# For character vectors, instead of a data frame, use this function
llm_vec_extract("bob smith, 123 3rd street", c("name", "address"))

# To preview the first call that will be made to the downstream R function
llm_vec_extract(
  "bob smith, 123 3rd street",
  c("name", "address"),
  preview = TRUE
)
}
}
