% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_lovecraft.R
\name{fetch_lovecraft}
\alias{fetch_lovecraft}
\title{Fetch Lovecraft's Stories from the H.P. Lovecraft Archive}
\usage{
fetch_lovecraft(url = NULL, trim = NULL)
}
\arguments{
\item{url}{A character string containing the URL of a specific H.P. Lovecraft story.
If `NULL`, the function returns a list of available stories and their links.}

\item{trim}{A vector of indices specifying which lines of the text to keep/trim.
If `NULL`, all lines of the text are returned.}
}
\value{
If a valid URL is provided, the function returns a data frame with two columns:

 \describe{
  \item{text}{A vector containing the story's text split into lines.}
    \item{title}{The title of the story.}
  }
  If no URL is provided, the function returns a data frame with two columns:
  \describe{
    \item{name}{The name of the story.}
    \item{link}{The URL from which the story can be downloaded.}
  }
}
\description{
The `fetch_lovecraft` function retrieves text from stories by H.P. Lovecraft from the H.P. Lovecraft Archive.
If no URL is provided, it returns a data frame listing all available stories with download links.
If a valid URL is given, it fetches and returns the text from that specific story.
}
\examples{

\donttest{

#' # List all available stories
fetch_lovecraft()

# Retrieve a story
fetch_lovecraft("https://www.hplovecraft.com/writings/texts/fiction/mm.aspx")

}


}
\references{
\emph{H.P. Lovecraft Archive}: \url{https://www.hplovecraft.com/}.
}
