% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listenv,dims.R
\name{dim_na}
\alias{dim_na}
\alias{dim_na<-}
\title{Set the dimension of an object}
\usage{
dim_na(x) <- value
}
\arguments{
\item{x}{An \R object, e.g. a list environment, a matrix, an array, or
a data frame.}

\item{value}{A numeric vector coerced to integers.
If one of the elements is missing, then its value is inferred from the
other elements (which must be non-missing) and the length of \code{x}.}
}
\value{
An object with the dimensions set, similar to what
\code{\link[base:dim]{dim(x) <- value}} returns.
}
\description{
Set the dimension of an object
}
\examples{
x <- 1:6
dim_na(x) <- c(2, NA)
print(dim(x))  ## [1] 2 3

}
