% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{setWindow}
\alias{setWindow}
\title{Set the current visible window}
\usage{
setWindow(id, start, end, options)
}
\arguments{
\item{id}{graph2d id or a \code{linevis} object (the output from \code{linevis()})}

\item{start}{The start date/time to show in the graph2d}

\item{end}{The end date/time to show in the graph2d}

\item{options}{Named list of options controlling mainly the animation.
Most common option is \code{animation = TRUE/FALSE}. For a full list of
options, see the "setWindow" method in the
\href{https://visjs.github.io/vis-timeline/docs/graph2d/#Methods}{official
graph2d documentation}}
}
\value{
None, side-effect is Javascript call
}
\description{
Set the current visible window
}
\examples{
\dontrun{
linevis() \%>\%
  setWindow(Sys.Date() - 1, Sys.Date() + 1)
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    linevisOutput("graph2d"),
    actionButton("btn", "Set window to show between yesterday to tomorrow")
  ),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis()
    )
    observeEvent(input$btn, {
      setWindow("graph2d", Sys.Date() - 1, Sys.Date() + 1)
    })
  }
)
}
}
