% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assume.R
\name{lock_nrow}
\alias{lock_nrow}
\title{Assert row count within expected range}
\usage{
lock_nrow(.data, min = 1, max = Inf, expected = NULL, .strict = FALSE)
}
\arguments{
\item{.data}{A data frame.}

\item{min}{Minimum expected rows (inclusive). Default 1.}

\item{max}{Maximum expected rows (inclusive). Default Inf.}

\item{expected}{Exact expected row count. If provided, overrides min/max.}

\item{.strict}{If \code{TRUE}, error on failure. If \code{FALSE} (default), warn.}
}
\value{
Invisibly returns \code{.data} (for piping).
}
\description{
Checks that the number of rows is within an expected range.
Useful for sanity checks after filtering or joins.
}
\examples{
df <- data.frame(id = 1:100)
lock_nrow(df, min = 50, max = 200)
lock_nrow(df, expected = 100)

}
