% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/programming_helpers.R
\name{\%not\%}
\alias{\%not\%}
\alias{\%not\%<-}
\alias{\%just\%}
\alias{\%just\%<-}
\alias{\%not\%.default}
\alias{\%not\%<-.default}
\alias{\%not\%.data.frame}
\alias{\%not\%<-.data.frame}
\alias{\%not\%.matrix}
\alias{\%not\%<-.matrix}
\alias{\%not\%.list}
\alias{\%not\%<-.list}
\alias{\%just\%.default}
\alias{\%just\%<-.default}
\alias{\%just\%.data.frame}
\alias{\%just\%<-.data.frame}
\alias{\%just\%.matrix}
\alias{\%just\%<-.matrix}
\alias{\%just\%.list}
\alias{\%just\%<-.list}
\title{Subsetting operators}
\usage{
x \%not\% y

x \%not\% y <- value

x \%just\% y

x \%just\% y <- value

\method{\%not\%}{default}(x, y)

\method{\%not\%}{default}(x, y) <- value

\method{\%not\%}{data.frame}(x, y)

\method{\%not\%}{data.frame}(x, y) <- value

\method{\%not\%}{matrix}(x, y)

\method{\%not\%}{matrix}(x, y) <- value

\method{\%not\%}{list}(x, y)

\method{\%not\%}{list}(x, y) <- value

\method{\%just\%}{default}(x, y)

\method{\%just\%}{default}(x, y) <- value

\method{\%just\%}{data.frame}(x, y)

\method{\%just\%}{data.frame}(x, y) <- value

\method{\%just\%}{matrix}(x, y)

\method{\%just\%}{matrix}(x, y) <- value

\method{\%just\%}{list}(x, y)

\method{\%just\%}{list}(x, y) <- value
}
\arguments{
\item{x}{Object to subset}

\item{y}{List of items to include if they are/aren't in \code{x}}

\item{value}{The object(s) to assign to the subsetted \code{x}}
}
\value{
All of \code{x} that are in \code{y} (\verb{\%just\%}) or all of \code{x} that are not in
\code{y} (\verb{\%not\%}).
}
\description{
\verb{\%just\%} and \verb{\%not\%} are subsetting convenience functions
for situations when you would do \code{x[x \%in\% y]} or \code{x[x \%nin\% y]}. See
details for behavior when \code{x} is a data frame or matrix.
}
\details{
The behavior of \verb{\%not\%} and \verb{\%just\%} are different when you're subsetting
data frames or matrices. The subset \code{y} in this case is interpreted as
\strong{column} names or indices.

You can also make assignments to the subset in the same way you could if
subsetting with brackets.
}
\examples{

 x <- 1:5
 y <- 3:8
 
 x \%just\% y # 3 4 5
 x \%not\% y # 1 2

 # Assignment works too
 x \%just\% y <- NA # 1 2 NA NA NA
 x \%not\% y <- NA # NA NA 3 4 5
 
 mtcars \%just\% c("mpg", "qsec", "cyl") # keeps only columns with those names
 mtcars \%not\% 1:5 # drops columns 1 through 5

 # Assignment works for data frames as well
 mtcars \%just\% c("mpg", "qsec") <- gscale(mtcars, c("mpg", "qsec"))
 mtcars \%not\% c("mpg", "qsec") <- gscale(mtcars \%not\% c("mpg", "qsec"))
 
 
}
\seealso{
Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}

Other subsetters: 
\code{\link{\%nin\%}()}
}
\concept{subsetters}
