% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir_bc.R
\name{ir_bc_polynomial}
\alias{ir_bc_polynomial}
\title{Performs baseline correction on infrared spectra using a polynomial}
\usage{
ir_bc_polynomial(x, degree = 2, return_bl = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}}.}

\item{degree}{An integer value representing the degree of the polynomial
used for baseline correction.}

\item{return_bl}{A logical value indicating if for each spectrum the baseline
should be returned instead of the corrected intensity values
(\code{return_bl = TRUE}) or not (\code{return_bl = FALSE}).}

\item{...}{Ignored.}
}
\value{
An object of class \code{ir} with the baseline corrected spectra if
\code{returnbl = FALSE} or the baselines if \code{returnbl = TRUE}.
}
\description{
\code{ir_bc_polynomial} performs baseline correction for infrared
spectra using a polynomial.
\code{ir_bc_polynomial} is an extended wrapper function
for \code{\link[ChemoSpec:baselineSpectra]{ChemoSpec::baselineSpectra()}}.
}
\examples{
if(! requireNamespace("ChemoSpec", quietly = TRUE)) {
  x2 <-
     ir::ir_sample_data |>
     ir::ir_bc_polynomial(degree = 2, return_bl = FALSE)
}

}
\seealso{
\code{\link[=ir_bc]{ir_bc()}}
}
