% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcStats.R
\name{calcStats}
\alias{calcStats}
\title{Extract statistics from events}
\usage{
calcStats(srt, end, data, f.vec = c("which.max", "max", "min"))
}
\arguments{
\item{srt}{Vector of indices for the event start}

\item{end}{Vector of indices for the event end}

\item{data}{Vector of data}

\item{f.vec}{c("which.max", "max", "min") Functions to be applied to the events}
}
\value{
Returns a dataframe where the row is each event and the column is each statistic. If \code{which.min} or
\code{which.max} are called the indices returned are global, that is, relative to the start of \code{data}.
}
\description{
Given the start and end indices of events statistics are calculated for the values in
between the start and end points inclusive.
}
\examples{
# Extract event statistics and plot the maxima
event.indices = eventPOT(dataLoch, out.style = "none")
event.stats = calcStats(event.indices$srt, event.indices$end, dataLoch)
print(event.stats)

plot(1:length(dataLoch), dataLoch, type = "h", lwd = 2, col = "steelblue",
     ylab = "Rainfall (mm)", xlab = "Time index", mgp = c(2, 0.6, 0))
points(event.stats$which.max, event.stats$max, col = "red", pch = 16, cex = 1.2)
legend("topright", legend = c("Rainfall", "Max"), cex = 0.8,
       lwd = c(2, NA), pch = c(NA, 16), col = c("steelblue", "red"), bty = "n")
}
\seealso{
\code{\link{eventPOT}} \code{\link{eventBaseflow}} \code{\link{eventMaxima}} \code{\link{eventMinima}}
}
\keyword{events}
