% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterLevelDataFrame-methods.R
\name{getRiver}
\alias{getRiver}
\alias{getRiver,WaterLevelDataFrame-method}
\alias{getRiver-method}
\title{Extract a WaterLevelDataFrame's slot river}
\usage{
getRiver(x)

\S4method{getRiver}{WaterLevelDataFrame}(x)
}
\arguments{
\item{x}{an object of class \linkS4class{WaterLevelDataFrame}.}
}
\value{
The function above extracts the slot \code{river}
  and returns an object of class \code{character}.
}
\description{
A function to extract the slot \code{river} from an object
  of class \linkS4class{WaterLevelDataFrame}.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
getRiver(wldf)

}
\seealso{
\code{\link[=setRiver<-]{setRiver<--method}}
}
