% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-schema.R
\name{get_schema_version_latest}
\alias{get_schema_version_latest}
\title{Get the latest schema version}
\usage{
get_schema_version_latest(schema_version = "latest", branch = "main")
}
\arguments{
\item{schema_version}{A character vector. Either "latest" or a valid schema version.}

\item{branch}{The branch of the hubverse
\href{https://github.com/hubverse-org/schemas}{schemas repository}
from which to fetch schema. Defaults to \code{"main"}.}
}
\value{
a schema version string. If \code{schema_version} is "latest", the latest schema
version from the schema repository. If specific version provided to \code{schema_version}, the same version is returned.
}
\description{
Get the latest schema version from the schema repository if "latest" requested
(default) or ignore if specific version provided.
}
\examples{
# Get the latest version of the schema
\dontshow{if (asNamespace("hubUtils")$not_rcmd_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_schema_version_latest()
get_schema_version_latest(schema_version = "v3.0.0")
\dontshow{\}) # examplesIf}
}
