\name{hh}
\alias{hh}
\title{Heatmap of Half-sibs}
\description{
Creates a heatmap of a half-sib dataset using an opposing-homozygotes (OH) matrix, with optional sidebars showing inferred and/or real pedigree groupings.
}
\usage{
hh(oh, inferredPedigree, realPedigree, pedOnly = TRUE)
}
\arguments{
  \item{oh}{
    \code{matrix}. Opposing-homozygotes matrix (e.g. output of \code{\link{ohg}}).
  }
  \item{inferredPedigree}{
    \code{matrix}. Inferred pedigree (e.g. output of \code{\link{rpoh}}).
  }
  \item{realPedigree}{
    \code{matrix}. Original pedigree.
  }
  \item{pedOnly}{
    \code{logical}. If \code{TRUE}, consider only individuals that exist in the real pedigree.
  }
}
\value{
Returns a heatmap of the OH matrix with sidebars color-coded by sire groups from the inferred and original pedigrees (where provided).
}
\author{
The function uses colors generated by the \emph{getcol} function in the \emph{made4} package (Aedin Culhane).
}
\seealso{
\code{\link{ohg}} and \code{\link{rpoh}}
}
\examples{
c1h1 <- .simulateHalfsib(numInd = 62, numSNP = 5000)
c1h2 <- .simulateHalfsib(numInd = 38, numSNP = 5000)
Genotype <- rbind(c1h1, c1h2)

oh <- ohg(Genotype)
hh(oh)
}
\keyword{heatmap}
\keyword{pedigree}
